DownGse<-function(gse_in)
{
Try({
	if(as.numeric(tclvalue(Stage))<2)
	{
		tkmessageBox(message="Please make sure you have selected your project.");
		return();
	}
	a=getGEO(gse_in, GSEMatrix = TRUE,destdir =tclvalue(Path.project))
	sample.list=sampleNames(phenoData(a[[1]]))
	if(length(sample.list)==0) 
	{
		tkmessageBox(title="Error",message="No data match your request!",icon="error",type="ok")
		return();
	}
	if(!file.exists(gse_in)) dir.create(gse_in)
	for(i in 1:length(sample.list)) 
	{
		Try({
		getGEOSuppFiles(sample.list[i],makeDirectory=F,baseDir=paste(tclvalue(Path.project),"/",gse_in,sep="")) #GSM filenames
		});
	}
	filelist=dir(gse_in);
	for(i in 1: length(filelist))
	{
		tmp=filelist[i];
		if(substring(tmp,nchar(tmp)-2)==".gz") gunzip(paste(tclvalue(Path.project),"/",gse_in,"/",tmp,sep=""), overwrite = T);
	}
});
}
DownGds<-function(gds_in)
{
#downloud GDS
Try({
	if(!file.exists("GEOmetadb.sqlite")) getSQLiteFile()
	#file.info("GEOmetadb.sqlite")
	con <- dbConnect(SQLite(), "GEOmetadb.sqlite")
	#geo_tables <- dbListTables(con)
	rs <- dbGetQuery(con, paste("select * from gds_subset where gds='",gds_in,"'",sep=""));
	sample.class=length(rs$sample_id);
	if(sample.class==0) 
	{
		tkmessageBox(title="Error",message="No data match your request!",icon="error",type="ok")
		return();
	}
	sample.subclass=array(0,sample.class)
	sample.list=list();
	tmp1=c();tmp2=c();
	for(i in 1:sample.class)
	{
		sample.subclass[i]=length(strsplit(rs$sample_id[[i]],",")[[1]])
		sample.list[i]=strsplit(rs$sample_id[[i]],",")[1];
		tmp1=c(tmp1,sample.list[[i]]);
		tmp2=c(tmp2,rep(rs$description[i],sample.subclass[i]))
	}
	if(!file.exists(gds_in)) dir.create(gds_in)
	for(i in 1:sample.class) 
		for(j in 1:sample.subclass[i])
		{
			getGEOSuppFiles(sample.list[[i]][j],makeDirectory=F,baseDir=paste(tclvalue(Path.project),"/",gds_in,sep="")) #GSM filenames
			#gunzip(paste(tclvalue(Path.project),"/",gds_in,"/",sample.list[[i]][j],".CEL.gz",sep=""), overwrite = T);
		}
	filelist=dir(gds_in);
	for(i in 1: length(filelist))
	{
		tmp=filelist[i];
		if(substring(tmp,nchar(tmp)-2)==".gz") gunzip(paste(tclvalue(Path.project),"/",gds_in,"/",tmp,sep=""), overwrite = T);
	}
});

}
DownGsm<-function(gsm_in)
{
#download GSM file
Try({
	a=getGEOSuppFiles(gsm_in,makeDirectory=F,baseDir=tclvalue(Path.project)) #GSM filenames
	#gunzip(paste(tclvalue(Path.project),"/",gsm_in,".CEL.gz",sep=""), overwrite = T);
});
}

DownArrayExpress<-function(ae_in)
{
#download AE files based on ArrayExpress identifier
Try({
	dbstring=ae_in; 
	p=paste(tclvalue(Path.project),"/",dbstring,sep="");
	if(!file.exists(p)) dir.create(p);
	tmp=getAE(dbstring, path = p, type = "raw", extract = TRUE);
});
}
AffyDownload<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<2)
	{
		tkmessageBox(message="Please select the project first!");
		return();
	}
	tkconfigure(tt,cursor="watch")	
	Input.AffyDownload();
	tkconfigure(tt,cursor="arrow")	
});
}
