Power.power<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}
	tkconfigure(tt,cursor="watch")
	an=Input.power();

	
	if(an$ReturnVal==0) {tkconfigure(tt,cursor="arrow");return();}
	if(an$Treatment=="UnSelected" | an$Control=="UnSelected") {tkconfigure(tt,cursor="arrow");return();}
	if(is.na(as.numeric(an$pw)) | is.na(as.numeric(an$nn)) | is.na(as.numeric(an$sl)) | is.na(as.numeric(an$fg))) {tkconfigure(tt,cursor="arrow");return();}

	#obs=as.numeric(an$pw);
	n=as.numeric(an$nn);
	sig.level=as.numeric(an$sl)
	fold.change=as.numeric(an$fg);

	trt=an$Treatment;
	control=an$Control;
	control_label=data.info[,trt]%in%control
	control_data=exprs(data.eset)[,control_label]

	exp.sd=apply(control_data,1,sd);
#######################################################
	path.output=paste(tclvalue(Path.project),"/PowerAnalysis",sep="");
	output_path2=path.output;
	if(!file.exists(output_path2)) dir.create(output_path2,recursive=T)
	out_names="Power.Power";
	filename=paste(path.output,"/",out_names,".pdf",sep="");
	pdf(file=filename);

	plotnames="Percent Of Gene Detected Versus Power";
	all.power=pow(sd=exp.sd,n=n,delta=log2(fold.change),sig.level=sig.level);
	  power.plot(all.power,lwd=2,col="blue");
	  xmax=par("usr")[2]-0.05;
	  ymax=par("usr")[4]-0.05;
      legend(x=xmax,y=ymax,legend=strsplit(paste("n=",n,",",
				"fold change=",fold.change,",",
				"alpha=",sig.level, ",",
				"total number of genes=",nobs(exp.sd),sep=''),",")[[1]],
				xjust=1, yjust=1, cex=1.0);
      title(plotnames,cex.main=0.8);
	dev.off();
############################################################
	tkmessageBox(message=paste("The file has been save as: \n",filename,sep=""),icon="info",type="ok")
	tkconfigure(tt,cursor="arrow");
	tkfocus(tt);
});
}
	