Power.samplesize<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please Finish the previous step!");
		tkfocus(tt);return();
	}
	tkconfigure(tt,cursor="watch")
	an=Input.samplesize();

	
	if(an$ReturnVal==0) {tkconfigure(tt,cursor="arrow");return();}
	if(an$Treatment=="UnSelected" | an$Control=="UnSelected") {tkconfigure(tt,cursor="arrow");return();}
	if(is.na(as.numeric(an$pw)) | is.na(as.numeric(an$nn)) | is.na(as.numeric(an$sl)) | is.na(as.numeric(an$fg))) {tkconfigure(tt,cursor="arrow");return();}

	power=as.numeric(an$pw);
	sig.level=as.numeric(an$sl)
	fold.change=as.numeric(an$fg);

	trt=an$Treatment;
	control=an$Control;
	control_label=data.info[,trt]%in%control
	control_data=exprs(data.eset)[,control_label]
	
	exp.sd=apply(control_data,1,sd);
	all.size=ssize(sd=exp.sd,delta=log2(fold.change),sig.level=sig.level,power=power);
	
#################################################################
	path.output=paste(tclvalue(Path.project),"/PowerAnalysis",sep="");
	output_path2=path.output;
	if(!file.exists(output_path2)) dir.create(output_path2,recursive=T)
	out_names="Power.SampleSize";
	filename=paste(path.output,"/",out_names,".pdf",sep="");
	pdf(file=filename);

	plotnames="Percent Of Gene Detected Versus Sample Size";
	all.size=ssize(sd=exp.sd,delta=log2(fold.change),sig.level=sig.level,power=power);
	ssize.plot(all.size,lwd=2,col="magenta",xlim=c(1,20));
	xmax=par("usr")[2]-0.03;
      	ymin=par("usr")[3]+0.05;
      	legend(x=xmax,y=ymin,legend=strsplit( paste("fold change=",fold.change,",", "alpha=", 				sig.level, ",","power=",power,",",
	"total number of genes=",nobs(exp.sd), sep=''), ",") [[1]],
       	xjust=1, yjust=0,cex=1.0);
      	title(plotnames,cex.main=0.8);
	dev.off();
#####################################################################
	tkmessageBox(message=paste("The file has been save as: \n",filename,sep=""),icon="info",type="ok")
	tkconfigure(tt,cursor="arrow");
	tkfocus(tt);
});
}