# Install the required packages
InstallPackage<-function()
{

tmp.list=ls(envir=.GlobalEnv)
sel="biocinstall" %in% tmp.list;
if(!sel) 
{
source("http://bioconductor.org/biocLite.R")
}
#get the installed packages
a=library();
InLib=a$results[,1];

#the list of required packages
toInstall=c(
#base packages:
		"affy",
		"affyPLM",
	      "gcrma",
	    "affyQCReport",
	    "simpleaffy",
	    "biomaRt",
	    "limma",
            "siggenes",
	    "arrayQualityMetrics",
            "vsn",
            "genefilter",
            "annaffy",
	    "ssize",
	    "made4",
            "lumi",
            "GEOquery",
	    "ArrayExpress",
            "GEOmetadb",
		"RankProd",
		"maSigPro",
#Annotation packages for Illumina
	    "lumiHumanAll.db",
	    "lumiMouseAll.db",
	    "lumiRatAll.db",
            "lumiHumanIDMapping",
            "lumiMouseIDMapping",
            "lumiRatIDMapping",
	"illuminaHumanv1.db",
	"illuminaHumanv2.db",
	"illuminaHumanv3.db",
	"illuminaMousev1.db",
	"illuminaMousev2.db",
	"illuminaRatv1.db"
)

# find the unstored packages
store=toInstall %in% InLib
unstore=!store

#install
if(length(toInstall[unstore])!=0) 
{
biocLite(toInstall[unstore])
message(paste("Packages Installed: ",toInstall[unstore],"\n",sep=""))
}else{message("No Packages Installed")}

#for the local packages:

toInstall.local.source=Install.LocalPackage.list();
toInstall.local.name=array("",length(toInstall.local.source));

if(length(toInstall.local.source)>=1)
{
	for(i in 1:length(toInstall.local.source))
	{
		tmp=unlist(strsplit(toInstall.local.source[i],"/"));
		tmp=tmp[length(tmp)];
        	#print(tmp);
		tmp2=unlist(strsplit(tmp,"_"))[1];
		toInstall.local.name[i]=tmp2;
	}
}
store.local=toInstall.local.name %in% InLib;
unstore.local=!store.local;

toInstall.local=toInstall.local.source[unstore.local];

print(length(toInstall.local));

#VersionRequiredList=c("AnnotationDbi","org.Rn.eg.db","org.Hs.eg.db","org.Mm.eg.db");
#VersionRequired=c("1.12.0","2.4.6","2.4.6","2.4.6")
#for(i in 1:length(VersionRequiredList))
#{
#	Tmp.version=packageDescription(VersionRequiredList[i],fields="Version")
#	if(compareVersion(Tmp.version,VersionRequired[i])!=1)
#	{
#		to.Update=grep(VersionRequiredList[i],toInstall.local.source)
#		#detach(VersionRequiredList[i])		
#		install.packages(toInstall.local.source[to.Update],dependencies=T,type="source")
#	}
#}


if(length(toInstall.local)>0)
{
	for(i in 1:length(toInstall.local))
	{
	#print(toInstall.local);
	install.packages(toInstall.local[i],dependencies=T,type="source")
	}
}

#Load required packages

#the list of required packages

	library(affy)
	library(gcrma)
	TryInstall(library(affyQCReport))
	library(simpleaffy)
	library(biomaRt)
	library(limma)
	library(siggenes)
	TryInstall(library(arrayQualityMetrics))
	library(vsn)
	library(genefilter)
	library(annaffy)
	library(ssize)
	library(made4)
	library(lumi)
	library(GEOquery)
	library(ArrayExpress)
	library(GEOmetadb)
	TryInstall(library(farms));
	library(RankProd)
 	library(maSigPro)
#########################################
#Illumina Annotation
	library(illuminaHumanv1.db)
	library(illuminaHumanv2.db)
	library(illuminaHumanv3.db)
	library(illuminaMousev1.db)
	library(illuminaMousev2.db)
	library(illuminaRatv1.db)
	library(lumiHumanAll.db)
	library(lumiMouseAll.db)
	library(lumiRatAll.db)
	library(lumiHumanIDMapping)
	library(lumiMouseIDMapping)
	library(lumiRatIDMapping)

	message("Required Packaged Loaded")
}
