UpStage<-function(index,mess="Done",mess2="Done")
{
switch(as.character(index),
# stage 0: open existed project done.
	"0"={
	tkmessageBox(message="Project has been Loaded!")
	},
# stage 1: GUI initiation done.
	"1"={
	tclvalue(label.taskdone)="WorkFlow is ready to run."
	tclvalue(label.tasktodo)="Please create a new project or load an existing Project."
	},
# stage 2: create new project done.
	"2"={
	tkmessageBox(message="Project has been Created!")
	tclvalue(label.taskdone)=paste("Project ",tclvalue(Project.Name)," was created.",sep="");
	tclvalue(label.tasktodo)="Please Import data";
	},
# stage 3: choose data type done.
	"3"={
	tkmessageBox(message=paste("You have selected Data Type: ",tclvalue(Data.Type),sep=""));
	tclvalue(label.taskdone)=paste("Data Type ",tclvalue(Data.Type)," was selected.",sep="");
	tclvalue(label.tasktodo)="Please select your design file.";
	},
# stage 4 & 5: Import Raw Data done.
	"5"={
	tkmessageBox(message="Data loading completed!");
	tclvalue(label.taskdone)="Data import completed! Please type data.raw to specify.";
	tclvalue(label.tasktodo)="Please save project (recommended), and import the design file.";
	tclvalue(RawData.Bool)="Import Completed";
	MarkStep(RawData.Bool);
	MarkStep(ChipType);
	},
# stage 6 & 7: Readin Design file done.
	"7"={
	tkmessageBox(message=paste("You have selected design file: ",tclvalue(Name.readfile),sep=""))
	tclvalue(label.taskdone)=paste("The design file selected was ",tclvalue(Name.readfile),sep="");
	tclvalue(label.tasktodo)="You may now proceed to the Data Preprocessing step.";
	tclvalue(DesignTable.Bool)="Import Completed";
	MarkStep(DesignTable.Bool);
	},
# stage 8: Preprocessing and Annotation done.
	"8"={
	tclvalue(label.taskdone)="Costumized CDF has been Choosen!";
	tclvalue(label.tasktodo)="Please go to Preprocessing and Annotation Step!";
	MarkStep(UsedCDF);
	},
# stage 9 & 10: Preprocessing and Annotation done.
	"10"={
	tkmessageBox(message="Preprocessed data is Saved.");
	tclvalue(label.taskdone)="Preprocessing and Annotation completed!";
	tclvalue(label.tasktodo)="You may perform the quality control or data exploring now";
	tclvalue(PreproData.Bool)=mess;
	tclvalue(Anno.Bool)=mess2;
	MarkStep(PreproData.Bool);
	MarkStep(Anno.Bool);
	},
# stage 11: QC done.
	"11"={
	tkmessageBox(message="Quality control analysis completed! \nThe results have been saved in the 'QC' folder.")
	tclvalue(label.taskdone)="Quality control analysis completed! The results have been saved in 'QC' folder";
	tclvalue(label.tasktodo)="You may check the graphs before performing the differential gene expression analysis.";
	tclvalue(QC.Bool)="Done";
	MarkStep(QC.Bool);
	},
# stage 12: differential gene expression done.
	"12"={
	tkmessageBox(message="Computation Finished!")
	message("Computation Finished!")
	tclvalue(label.taskdone)="Computation Finished! You may type out to specify the result";
	tclvalue(label.tasktodo)="You may now proceed to the Results Output step to output analysis results.";
	tclvalue(Differential.Gene.Modeling.Bool)=mess;
	MarkStep(Differential.Gene.Modeling.Bool);
	},
# stage 13: Gene List Generation done.
	"13"={
	tkmessageBox(message="Gene List has been generated!")
	message("Gene List has been generated!")
	tclvalue(label.taskdone)=paste("The list of ",dim(ga.output$result.filtered)[1]," Genes has been Generated!");
	tclvalue(label.tasktodo)="You could check the Gene list and Export the Result";
	tclvalue(Gene.List.Output.Bool)=mess;	
	MarkStep(Gene.List.Output.Bool);
	}
)
	if(index!=0) tclvalue(Stage)=index;
	cl=as.numeric(tclvalue(Stage));
	a=GetProperty();
	for(i in 1:13)
	{
		tmp.label=paste("v",i,sep="");
		if(i<=cl)
		{
		tkconfigure(get(tmp.label),textvariable=get(a[i,2]),font=fontHeading4,foreground="red");
	  	 }else{
		tkconfigure(get(tmp.label),textvariable=get(a[i,2]),font=fontHeading3,foreground="black");
	  	 }		
	}

}