#This function is used to draw the cluster to visualize the data
# using different clustering algorithm

DrawCluster<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please select the project first!");
		return();
	}
	tkconfigure(tt,cursor="watch")

	Try({
	an=Input.DrawCluster();
	if(as.numeric(an$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");return();}

	## Use correlations between variables "as distance"
	if(an$para1=="correlation")
	{
		data.eset.d =as.dist((1 - cor(exprs(data.eset)))/2);
	}else{
		data.eset.d=dist(t(exprs(data.eset)),method =an$para1)
	}
	tmp=hclust(data.eset.d,method=an$para2)
######################################################################
	path.output=paste(tclvalue(Path.project),"/QC/Cluster",sep="");
	output_path2=path.output;
	if(!file.exists(output_path2)) dir.create(output_path2,recursive=T)
	out_names=paste("Cluster_",an$para1,"_",an$para2,".pdf",sep="");
	filename=paste(path.output,"/",out_names,".pdf",sep="");
	pdf(file=filename);

	plot(tmp,hang=-1,sub ="", main="Hierarchical Cluster Analysis",
			xlab =an$para2,
             ylab=an$para1)
	});
	dev.off();
######################################################################
	tkmessageBox(message=paste("The file has been save as: \n",filename,sep=""),icon="info",type="ok")
	tkconfigure(tt,cursor="arrow");
	tkfocus(tt);
});

}