# this function is used to draw the graph to visualize the data
# using principle components algorithm
DrawPca<-function()
{
Try({
	if(as.numeric(tclvalue(Stage))<10)
	{
		tkmessageBox(message="Please select the project first!");
		return();
	}
	tkconfigure(tt,cursor="watch")

	an=Input.DrawPca();
	if(as.numeric(an$ReturnValue)!=1) {tkconfigure(tt,cursor="arrow");return();}

	data.pca=ord(exprs(data.eset), type = "pca")
	if(an$classfac=="UnSelected")
	{
		data.trt=array(1,dim(data.info)[1])	
	}else{ data.trt=data.info[,an$classfac];}

	#PCA data visualization by interaction
	#if(as.numeric(an$graph1)==1)
	#{
	#Try({
	#	tkmessageBox(message="Please click to make page change...");
	#	par(ask=T)
	#	for(i in 0:35)
	#	{
	#	do3d(data.pca$ord$co, classvec = data.trt,  angle = 10*i, cex.symbols = 3)
	#	}
	#	par(ask=F)
	#  });
	#}

	#PCA data visualization output to html
	if(as.numeric(an$graph2)==1)
	{
	Try({
		path=getwd()
		path.output=paste(tclvalue(Path.project),"/QC",sep="");
		pca.path="/PCA";
		output_path2=paste(path.output,pca.path,sep="");
		if(!file.exists(output_path2)) dir.create(output_path2,recursive=T)
		setwd(output_path2)
		html3D(data.pca$ord$co, data.trt, filenamebase = "PCA",writehtml = TRUE)
		tkmessageBox(message="the 3D graph has been saved!");
		setwd(path)
	});
	}
	tkfocus(tt);
	tkconfigure(tt,cursor="arrow");
});
}