\name{mgu74av2mmrefseqUNIPROT}
\alias{mgu74av2mmrefseqUNIPROT}
\alias{mgu74av2mmrefseqUNIPROT2PROBE}
\title{Map Uniprot accession numbers with Entrez Gene identifiers}  
\description{ 
  mgu74av2mmrefseqUNIPROT is an R object that contains mappings between 
  Entrez Gene identifiers and Uniprot accession numbers.    
}
\details{
  This object is a simple mapping of Entrez Gene identifiers
  \url{http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene} to Uniprot
  Accessions.

  Mappings were based on data provided by: Entrez Gene  
  ftp://ftp.ncbi.nlm.nih.gov/gene/DATA  
  With a date stamp from the source of: 2010-Mar1
}

\examples{
    x <- mgu74av2mmrefseqUNIPROT
    # Get the entrez gene IDs that are mapped to an Uniprot ID
    mapped_genes <- mappedkeys(x)
    # Convert to a list
    xx <- as.list(x[mapped_genes])
    if(length(xx) > 0) {
      # Get the Uniprot IDs for the first five genes
      xx[1:5]
      # Get the first one
      xx[[1]]
    }
}
\keyword{datasets}



