datacache <- new.env(hash=TRUE, parent=emptyenv())

hugene10stv1hsrefseq <- function() showQCData("hugene10stv1hsrefseq", datacache)
hugene10stv1hsrefseq_dbconn <- function() dbconn(datacache)
hugene10stv1hsrefseq_dbfile <- function() dbfile(datacache)
hugene10stv1hsrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hugene10stv1hsrefseq_dbInfo <- function() dbInfo(datacache)

hugene10stv1hsrefseqORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hugene10stv1hsrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hugene10stv1hsrefseq", "chip hugene10stv1hsrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hugene10stv1hsrefseq_dbconn())
}

