
\name{hugene10stv1hsrefseq_dbconn}

\alias{hugene10stv1hsrefseq_dbconn}
\alias{hugene10stv1hsrefseq_dbfile}
\alias{hugene10stv1hsrefseq_dbschema}
\alias{hugene10stv1hsrefseq_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  hugene10stv1hsrefseq_dbconn()
  hugene10stv1hsrefseq_dbfile()
  hugene10stv1hsrefseq_dbschema(file="", show.indices=FALSE)
  hugene10stv1hsrefseq_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{hugene10stv1hsrefseq_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{hugene10stv1hsrefseq_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{hugene10stv1hsrefseq_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{hugene10stv1hsrefseq_dbschema} prints the schema definition of the
  package annotation DB.

  \code{hugene10stv1hsrefseq_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{hugene10stv1hsrefseq_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{hugene10stv1hsrefseq_dbfile}: a character string with the path to the
  package annotation DB.

  \code{hugene10stv1hsrefseq_dbschema}: none (invisible \code{NULL}).

  \code{hugene10stv1hsrefseq_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(hugene10stv1hsrefseq_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by hugene10stv1hsrefseq_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=hugene10stv1hsrefseq_dbfile(), cache_size=64000,
  synchronous=0)

  hugene10stv1hsrefseq_dbschema()

  hugene10stv1hsrefseq_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

