datacache <- new.env(hash=TRUE, parent=emptyenv())

rgu34arnrefseq <- function() showQCData("rgu34arnrefseq", datacache)
rgu34arnrefseq_dbconn <- function() dbconn(datacache)
rgu34arnrefseq_dbfile <- function() dbfile(datacache)
rgu34arnrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
rgu34arnrefseq_dbInfo <- function() dbInfo(datacache)

rgu34arnrefseqORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "rgu34arnrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "rgu34arnrefseq", "chip rgu34arnrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(rgu34arnrefseq_dbconn())
}

