datacache <- new.env(hash=TRUE, parent=emptyenv())

rae230arnrefseq <- function() showQCData("rae230arnrefseq", datacache)
rae230arnrefseq_dbconn <- function() dbconn(datacache)
rae230arnrefseq_dbfile <- function() dbfile(datacache)
rae230arnrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
rae230arnrefseq_dbInfo <- function() dbInfo(datacache)

rae230arnrefseqORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "rae230arnrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "rae230arnrefseq", "chip rae230arnrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(rae230arnrefseq_dbconn())
}

