datacache <- new.env(hash=TRUE, parent=emptyenv())

hgu95av2hsrefseq <- function() showQCData("hgu95av2hsrefseq", datacache)
hgu95av2hsrefseq_dbconn <- function() dbconn(datacache)
hgu95av2hsrefseq_dbfile <- function() dbfile(datacache)
hgu95av2hsrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hgu95av2hsrefseq_dbInfo <- function() dbInfo(datacache)

hgu95av2hsrefseqORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hgu95av2hsrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hgu95av2hsrefseq", "chip hgu95av2hsrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hgu95av2hsrefseq_dbconn())
}

