datacache <- new.env(hash=TRUE, parent=emptyenv())

mouse430a2mmentrezg <- function() showQCData("mouse430a2mmentrezg", datacache)
mouse430a2mmentrezg_dbconn <- function() dbconn(datacache)
mouse430a2mmentrezg_dbfile <- function() dbfile(datacache)
mouse430a2mmentrezg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mouse430a2mmentrezg_dbInfo <- function() dbInfo(datacache)

mouse430a2mmentrezgORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mouse430a2mmentrezg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mouse430a2mmentrezg", "chip mouse430a2mmentrezg", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mouse430a2mmentrezg_dbconn())
}

