datacache <- new.env(hash=TRUE, parent=emptyenv())

moe430ammrefseq <- function() showQCData("moe430ammrefseq", datacache)
moe430ammrefseq_dbconn <- function() dbconn(datacache)
moe430ammrefseq_dbfile <- function() dbfile(datacache)
moe430ammrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
moe430ammrefseq_dbInfo <- function() dbInfo(datacache)

moe430ammrefseqORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "moe430ammrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "moe430ammrefseq", "chip moe430ammrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(moe430ammrefseq_dbconn())
}

