datacache <- new.env(hash=TRUE, parent=emptyenv())

rae230brnrefseq <- function() showQCData("rae230brnrefseq", datacache)
rae230brnrefseq_dbconn <- function() dbconn(datacache)
rae230brnrefseq_dbfile <- function() dbfile(datacache)
rae230brnrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
rae230brnrefseq_dbInfo <- function() dbInfo(datacache)

rae230brnrefseqORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "rae230brnrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "rae230brnrefseq", "chip rae230brnrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(rae230brnrefseq_dbconn())
}

