datacache <- new.env(hash=TRUE, parent=emptyenv())

hgu133ahsrefseq <- function() showQCData("hgu133ahsrefseq", datacache)
hgu133ahsrefseq_dbconn <- function() dbconn(datacache)
hgu133ahsrefseq_dbfile <- function() dbfile(datacache)
hgu133ahsrefseq_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hgu133ahsrefseq_dbInfo <- function() dbInfo(datacache)

hgu133ahsrefseqORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hgu133ahsrefseq.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hgu133ahsrefseq", "chip hgu133ahsrefseq", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hgu133ahsrefseq_dbconn())
}

