#include "Parser.h"

int AtoI(string& str)
{
	int res = atoi(str.c_str());
	if((res == 0) && (str[0] != '0'))
	{
		string err= "Invalid number " + str;
		throw err;
	}
	return res;
}

string ToUpper(string& str)
{
	string out;
	for(int i=0;i<str.length();i++)
	{
		out+=toupper(str[i]);
	}
	return out;
}

Parser::Parser(string fileName)
{
	m_File.open(fileName.c_str());
	if(!m_File.is_open())
	{
		string error = "Failed to open file " + fileName;
		throw error;
	}
	//we want to check what is the line delimiter, it could be \n or \n\r
	m_LineDelimiter = '\n';
	string line;	
	getline(m_File,line,m_LineDelimiter);
	int lineSize = line.size();
	m_File.seekg(0,ios::end);
	int filesize = m_File.tellg();
	
	// if \n is not the delimiter, the function getline would read the entire file (instead of one line)
	// and then filesize = linesize
	if(line.size() == m_File.tellg())
	{
		m_LineDelimiter = '\r';
		//from some odd reason - only the following procedure
		//resets the file into a good state (in case the wrong delimiter was first used)
		m_File.clear();
		m_File.close();
		m_File.open(fileName.c_str());	
		if(!m_File.is_open())
			{
				string error =  "Failed to open file " + fileName;
				throw error;
			}
	}
	else
	{
		m_File.seekg(0,ios::beg);
	}
	
}

Parser::~Parser(void)
{
	m_File.close();
}

void Parser::Tokenize(const string& str,
                      vector<string>& tokens,
                      const string& delimiters)
{
    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos     = str.find_first_of(delimiters, lastPos);

    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}

