/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.indexdb;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.KeyPair;
import org.biojava.bio.program.indexdb.SearchableFileAsList;

class SecondaryFileAsList
extends SearchableFileAsList {
    private Comparator KEY_VALUE_COMPARATOR = new Comparator(){

        public int compare(Object a, Object b) {
            String as = a.toString();
            String bs = b.toString();
            return BioStore.STRING_CASE_SENSITIVE_ORDER.compare(as, bs);
        }
    };

    public SecondaryFileAsList(File file, int recordLen) throws IOException {
        super(file, recordLen);
    }

    public SecondaryFileAsList(File file, boolean mutable) throws IOException {
        super(file, mutable);
    }

    protected Object parseRecord(byte[] buffer) {
        int tabI = 0;
        while (buffer[tabI] != 9) {
            ++tabI;
        }
        String prim = new String(buffer, 0, tabI);
        String sec = new String(buffer, ++tabI, buffer.length - tabI).trim();
        return new KeyPair.Impl(prim, sec);
    }

    protected void generateRecord(byte[] buffer, Object item) {
        int j;
        KeyPair kp = (KeyPair)item;
        int i = 0;
        byte[] str = null;
        try {
            str = kp.getPrimary().getBytes();
            for (j = 0; j < str.length; ++j) {
                buffer[i++] = str[j];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Over ran buffer with primary ID: " + new String(str) + " " + str.length + " : " + buffer.length + " index: " + i);
        }
        buffer[i++] = 9;
        try {
            str = kp.getSecondary().getBytes();
            for (j = 0; j < str.length && i < buffer.length; ++j) {
                buffer[i++] = str[j];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Over ran buffer with secondary ID: " + new String(str) + " " + str.length + " : " + buffer.length + " index: " + i);
        }
        while (i < buffer.length) {
            buffer[i++] = 32;
        }
    }

    public Comparator getComparator() {
        return this.KEY_VALUE_COMPARATOR;
    }
}

