/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.CollectionConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeVetoException;

public class AnnotationBuilder
implements TagValueListener {
    private List annotationStack;
    private AnnotationType type;
    private Annotation last;

    public AnnotationBuilder(AnnotationType type) {
        this.type = type;
        this.annotationStack = new ArrayList();
    }

    public Annotation getLast() {
        return this.last;
    }

    public void startRecord() {
        Frame top = new Frame();
        top.annotation = new SmallAnnotation();
        if (this.annotationStack.isEmpty()) {
            top.type = this.type;
        } else {
            Frame old = this.peek(this.annotationStack);
            CollectionConstraint cc = old.type.getConstraint(old.tag);
            PropertyConstraint pc = null;
            if (cc instanceof CollectionConstraint.AllValuesIn) {
                pc = ((CollectionConstraint.AllValuesIn)cc).getPropertyConstraint();
            }
            if (pc instanceof PropertyConstraint.ByAnnotationType) {
                PropertyConstraint.ByAnnotationType pcat = (PropertyConstraint.ByAnnotationType)pc;
                top.type = pcat.getAnnotationType();
            } else {
                top.type = AnnotationType.ANY;
            }
        }
        this.push(this.annotationStack, top);
    }

    public void endRecord() {
        Frame top = this.pop(this.annotationStack);
        this.last = top.annotation;
        if (!this.annotationStack.isEmpty()) {
            try {
                Frame old = this.peek(this.annotationStack);
                old.type.setProperty(old.annotation, old.tag, this.last);
            }
            catch (ChangeVetoException cve) {
                throw new AssertionFailure(cve);
            }
        }
    }

    public void startTag(Object tag) {
        this.peek((List)this.annotationStack).tag = tag;
    }

    public void value(TagValueContext ctxt, Object value) {
        try {
            Frame top = this.peek(this.annotationStack);
            top.type.setProperty(top.annotation, top.tag, value);
        }
        catch (ChangeVetoException cve) {
            throw new AssertionFailure(cve);
        }
    }

    public void endTag() {
    }

    private void push(List list, Frame frame) {
        list.add(frame);
    }

    private Frame peek(List list) {
        return (Frame)list.get(list.size() - 1);
    }

    private Frame pop(List list) {
        return (Frame)list.remove(list.size() - 1);
    }

    private static class Frame {
        public AnnotationType type;
        public Annotation annotation;
        public Object tag;

        private Frame() {
        }
    }
}

