/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.agave.AGAVEClassificationHandler;
import org.biojava.bio.seq.io.agave.AGAVEEvidenceHandler;
import org.biojava.bio.seq.io.agave.AGAVEFeatureCallbackItf;
import org.biojava.bio.seq.io.agave.AGAVENotePropHandler;
import org.biojava.bio.seq.io.agave.AGAVEProperty;
import org.biojava.bio.seq.io.agave.AGAVEQualifierPropHandler;
import org.biojava.bio.seq.io.agave.AGAVERelatedAnnot;
import org.biojava.bio.seq.io.agave.AGAVERelatedAnnotPropHandler;
import org.biojava.bio.seq.io.agave.AGAVESeqFeatureHandler;
import org.biojava.bio.seq.io.agave.AGAVESeqLocationPropHandler;
import org.biojava.bio.seq.io.agave.AGAVETranscriptHandler;
import org.biojava.bio.seq.io.agave.AGAVEXrefsPropHandler;
import org.biojava.bio.seq.io.agave.ElementRecognizer;
import org.biojava.bio.seq.io.agave.StAXContentHandler;
import org.biojava.bio.seq.io.agave.StAXFeatureHandler;
import org.biojava.bio.seq.io.agave.StAXHandlerFactory;
import org.biojava.bio.seq.io.agave.UtilHelper;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeVetoException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AGAVEGeneHandler
extends StAXFeatureHandler
implements AGAVEFeatureCallbackItf {
    public static final StAXHandlerFactory AGAVE_GENE_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new AGAVEGeneHandler(staxenv);
        }
    };

    AGAVEGeneHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.featureListener = staxenv.featureListener;
        this.setHandlerCharacteristics("gene", true);
        super.addHandler(new ElementRecognizer.ByLocalName("classification"), AGAVEClassificationHandler.AGAVE_CLASSIFICATION_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("note"), AGAVENotePropHandler.AGAVE_NOTE_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("seq_location"), AGAVESeqLocationPropHandler.AGAVE_SEQ_LOCATION_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("xrefs"), AGAVEXrefsPropHandler.AGAVE_XREFS_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("evidence"), AGAVEEvidenceHandler.AGAVE_EVIDENCE_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("qualifier"), AGAVEQualifierPropHandler.AGAVE_QUALIFIER_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("seq_feature"), AGAVESeqFeatureHandler.AGAVE_SEQ_FEATURE_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("related_annot"), AGAVERelatedAnnotPropHandler.AGAVE_RELATED_ANNOT_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("transcript"), AGAVETranscriptHandler.AGAVE_TRANSCRIPT_HANDLER_FACTORY);
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            this.featureListener.startFeature(this.featureTemplate);
            boolean forFeature = true;
            this.setProperty("element_id", attrs.getValue("element_id"), forFeature);
            this.setProperty("label", attrs.getValue("label"), forFeature);
            this.featureTemplate.type = "gene";
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    public void addProperty(AGAVEProperty prop) {
        try {
            Object ob = UtilHelper.getProperty(this.staxenv.featureTemplate.annotation, "qualifier");
            if (ob != null) {
                ((List)ob).add(prop);
            } else {
                ArrayList<AGAVEProperty> props = new ArrayList<AGAVEProperty>(1);
                props.add(prop);
                this.staxenv.featureTemplate.annotation.setProperty("qualifier", props);
            }
        }
        catch (ChangeVetoException cve) {
            cve.printStackTrace();
        }
    }

    public void reportFeature(Location loc) {
        ((StrandedFeature.Template)this.featureTemplate).location = loc;
    }

    public void reportStrand(StrandedFeature.Strand strand) {
        ((StrandedFeature.Template)this.featureTemplate).strand = strand;
    }

    public void addRelatedAnnot(AGAVERelatedAnnot prop) {
        try {
            Object ob = UtilHelper.getProperty(this.staxenv.featureTemplate.annotation, "related_annot");
            if (ob != null) {
                ((List)ob).add(prop);
            } else {
                ArrayList<AGAVERelatedAnnot> props = new ArrayList<AGAVERelatedAnnot>(1);
                props.add(prop);
                this.staxenv.featureTemplate.annotation.setProperty("related_annot", props);
            }
        }
        catch (ChangeVetoException cve) {
            cve.printStackTrace();
        }
    }
}

