/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.Collections;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ListTools;

public final class AlphaCTools {
    public static final double MAX_ANGLE = 180.0;
    public static final double MIN_ANGLE = -180.0;
    private static String ALPHA = "ALPHA CARBON ANGLES";
    private static DoubleAlphabet daInstance = DoubleAlphabet.getInstance();

    public static Alphabet getAlphaCarbonAngleAlphabet() {
        if (AlphabetManager.registered(ALPHA)) {
            return AlphabetManager.alphabetForName(ALPHA);
        }
        List<DoubleAlphabet> l = Collections.nCopies(2, DoubleAlphabet.getInstance());
        try {
            Alphabet a = AlphabetManager.getCrossProductAlphabet(l, ALPHA);
            AlphabetManager.registerAlphabet(ALPHA, a);
            return a;
        }
        catch (IllegalAlphabetException ex) {
            throw new BioError("Cannot construct " + ALPHA + " alphabet", ex);
        }
    }

    public static Symbol getPhiPsiSymbol(double phiAngle, double psiAngle) throws IllegalSymbolException {
        if (phiAngle > 180.0 || phiAngle < -180.0) {
            throw new IllegalSymbolException("Phi angle must be between -180.0 and +180.0");
        }
        if (psiAngle > 180.0 || psiAngle < -180.0) {
            throw new IllegalSymbolException("Psi angle must be between -180.0 and +180.0");
        }
        DoubleAlphabet.DoubleSymbol phi = daInstance.getSymbol(phiAngle);
        DoubleAlphabet.DoubleSymbol psi = daInstance.getSymbol(psiAngle);
        return AlphaCTools.getAlphaCarbonAngleAlphabet().getSymbol(new ListTools.Doublet(phi, psi));
    }

    public static double getPhiAngle(Symbol phiPsiSym) throws IllegalSymbolException {
        AlphaCTools.getAlphaCarbonAngleAlphabet().validate(phiPsiSym);
        List l = ((BasisSymbol)phiPsiSym).getSymbols();
        return ((DoubleAlphabet.DoubleSymbol)l.get(0)).doubleValue();
    }

    public static double getPsiAngle(Symbol phiPsiSym) throws IllegalSymbolException {
        AlphaCTools.getAlphaCarbonAngleAlphabet().validate(phiPsiSym);
        List l = ((BasisSymbol)phiPsiSym).getSymbols();
        return ((DoubleAlphabet.DoubleSymbol)l.get(1)).doubleValue();
    }
}

