/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.ArrayList;
import org.biojava.bio.Annotation;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;

public class ChainImpl
implements Chain {
    String swissprot_id;
    String name = "";
    ArrayList groups = new ArrayList();
    Annotation annotation;

    public ChainImpl() {
        Annotation anno = Annotation.EMPTY_ANNOTATION;
    }

    public Object clone() {
        ChainImpl n = new ChainImpl();
        n.setName(this.getName());
        n.setSwissprotId(this.getSwissprotId());
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = (Group)this.groups.get(i);
            n.addGroup((Group)g.clone());
        }
        return n;
    }

    public void setAnnotation(Annotation anno) {
        this.annotation = anno;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setSwissprotId(String sp_id) {
        this.swissprot_id = sp_id;
    }

    public String getSwissprotId() {
        return this.swissprot_id;
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    public Group getGroup(int position) {
        return (Group)this.groups.get(position);
    }

    public ArrayList getGroups(String type) {
        ArrayList<Group> tmp = new ArrayList<Group>();
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = (Group)this.groups.get(i);
            if (!g.getType().equals(type)) continue;
            tmp.add(g);
        }
        return tmp;
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public int getLength() {
        return this.groups.size();
    }

    public int getLengthAminos() {
        ArrayList g = this.getGroups("amino");
        return g.size();
    }

    public void setName(String nam) {
        this.name = nam;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String str = "Chain >" + this.getName() + "< total length:" + this.getLength() + " residues";
        int i = 0;
        do {
            Group gr = (Group)this.groups.get(i);
            str = str + gr.toString() + "\n";
        } while (++i < this.groups.size());
        return str;
    }

    public String getSequence() {
        ArrayList aminos = this.getGroups("amino");
        StringBuffer sequence = new StringBuffer();
        for (int i = 0; i < aminos.size(); ++i) {
            AminoAcid a = (AminoAcid)aminos.get(i);
            sequence.append(a.getAminoType());
        }
        String s = sequence.toString();
        return s;
    }
}

