/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class ChangeSupport {
    private int listenerCount = 0;
    private int delta;
    private Set unchanging;
    private Reference[] listeners;
    private ChangeType[] types;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean hasListeners() {
        return this.listenerCount > 0;
    }

    public boolean hasListeners(ChangeType ct) {
        for (int i = 0; i < this.listenerCount; ++i) {
            ChangeType type = this.types[i];
            if (!type.isMatchingType(ct)) continue;
            return true;
        }
        return false;
    }

    public ChangeSupport() {
        this(5);
    }

    public ChangeSupport(int initialSize) {
        this(initialSize, 5);
    }

    public ChangeSupport(int initialSize, int delta) {
        this(Collections.EMPTY_SET, initialSize, delta);
    }

    public ChangeSupport(Set unchanging) {
        this(unchanging, 0, 5);
    }

    public ChangeSupport(Set unchanging, int initialSize, int delta) {
        this.listeners = new Reference[initialSize];
        this.types = new ChangeType[initialSize];
        this.delta = delta;
        this.unchanging = new HashSet(unchanging);
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (ct == null) {
            throw new NullPointerException("Since 1.2, listeners registered for the null changetype are not meaningful.  Please register a listener for ChangeType.UNKNOWN instead");
        }
        if (this.isUnchanging(ct)) {
            return;
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            this.growIfNecessary();
            this.types[this.listenerCount] = ct;
            this.listeners[this.listenerCount] = new WeakReference<ChangeListener>(cl);
            ++this.listenerCount;
        }
    }

    protected void growIfNecessary() {
        if (this.listenerCount == this.listeners.length) {
            int newLength = this.listenerCount + this.delta;
            Reference[] newList = new Reference[newLength];
            ChangeType[] newTypes = new ChangeType[newLength];
            System.arraycopy(this.listeners, 0, newList, 0, this.listenerCount);
            System.arraycopy(this.types, 0, newTypes, 0, this.listenerCount);
            this.listeners = newList;
            this.types = newTypes;
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            for (int i = 0; i < this.listenerCount; ++i) {
                if (this.listeners[i].get() != cl || this.types[i] != ct) continue;
                --this.listenerCount;
                System.arraycopy(this.listeners, i + 1, this.listeners, i, this.listenerCount - i);
                System.arraycopy(this.types, i + 1, this.types, i, this.listenerCount - i);
                return;
            }
        }
    }

    protected void reapGarbageListeners() {
        int pp = 0;
        for (int p = 0; p < this.listenerCount; ++p) {
            Reference r = this.listeners[p];
            if (r.get() == null) continue;
            this.types[pp] = this.types[p];
            this.listeners[pp] = r;
            ++pp;
        }
        this.listenerCount = pp;
    }

    public void firePreChangeEvent(ChangeEvent ce) throws ChangeVetoException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError((Object)"firePreChangeEvent must be called in a synchronized block locking the ChangeSupport");
        }
        boolean needToReap = false;
        ChangeType ct = ce.getType();
        int listenerCount = this.listenerCount;
        ChangeType[] types = new ChangeType[listenerCount];
        System.arraycopy(this.types, 0, types, 0, listenerCount);
        Reference[] listeners = new Reference[listenerCount];
        System.arraycopy(this.listeners, 0, listeners, 0, listenerCount);
        for (int i = 0; i < listenerCount; ++i) {
            ChangeType lt = types[i];
            if (!ct.isMatchingType(lt)) continue;
            ChangeListener cl = (ChangeListener)listeners[i].get();
            if (cl != null) {
                cl.preChange(ce);
                continue;
            }
            needToReap = true;
        }
        if (needToReap) {
            this.reapGarbageListeners();
        }
    }

    public void firePostChangeEvent(ChangeEvent ce) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError((Object)"firePostChangeEvent must be called in a synchronized block locking the ChangeSupport");
        }
        boolean needToReap = false;
        ChangeType ct = ce.getType();
        int listenerCount = this.listenerCount;
        ChangeType[] types = new ChangeType[listenerCount];
        System.arraycopy(this.types, 0, types, 0, listenerCount);
        Reference[] listeners = new Reference[listenerCount];
        System.arraycopy(this.listeners, 0, listeners, 0, listenerCount);
        for (int i = 0; i < listenerCount; ++i) {
            ChangeType lt = types[i];
            if (!ct.isMatchingType(lt)) continue;
            ChangeListener cl = (ChangeListener)listeners[i].get();
            if (cl != null) {
                cl.postChange(ce);
                continue;
            }
            needToReap = true;
        }
        if (needToReap) {
            this.reapGarbageListeners();
        }
    }

    public boolean isUnchanging(ChangeType ct) {
        if (this.unchanging == null) {
            return false;
        }
        Iterator i = ct.matchingTypes();
        while (i.hasNext()) {
            if (!this.unchanging.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public String displayString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        sb.append("\n");
        for (int i = 0; i < this.listenerCount; ++i) {
            sb.append("\t");
            sb.append(this.listeners[i].get());
            sb.append("\t");
            sb.append(this.types[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        $assertionsDisabled = !ChangeSupport.class.desiredAssertionStatus();
    }
}

