/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

public class RepeatedCharSequence
implements CharSequence {
    private int length;
    private char character;
    private StringBuffer sbuf;
    private String string;

    public RepeatedCharSequence(int length, char character) {
        this.length = length;
        this.character = character;
    }

    public RepeatedCharSequence() {
        this(0, ' ');
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length can't be negative: " + length);
        }
        if (this.sbuf != null) {
            if (length < this.length) {
                this.sbuf.setLength(length);
            } else {
                for (int i = this.length; i < length; ++i) {
                    this.sbuf.append(this.character);
                }
            }
        }
        if (this.length != length) {
            this.string = null;
        }
        this.length = length;
    }

    public char getCharacter() {
        return this.character;
    }

    public void setCharacter(char character) {
        this.character = character;
        this.flush();
    }

    public void flush() {
        this.sbuf = null;
        this.string = null;
    }

    public int length() {
        return this.length;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("Attempted to read from index " + index + " of " + this.length);
        }
        return this.character;
    }

    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start >= this.length || end < start || end > this.length) {
            throw new IndexOutOfBoundsException("Illegal indexes: " + start + "," + end + " of sequence length " + this.length);
        }
        return new RepeatedCharSequence(end - start, this.character);
    }

    public String toString() {
        if (this.string == null) {
            if (this.sbuf == null) {
                this.sbuf = new StringBuffer(this.length);
                for (int i = 0; i < this.length; ++i) {
                    this.sbuf.append(this.character);
                }
            }
            this.string = this.sbuf.toString();
        }
        return this.string;
    }
}

