/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class WMAsMM
extends AbstractChangeable
implements MarkovModel,
Serializable {
    private static final int[] advance = new int[]{1};
    private final WeightMatrix wm;
    private final FiniteAlphabet stateAlpha;
    private final MagicalState magicalState;
    private final EmissionState[] states;
    private final Map transFrom;
    private final Map transTo;
    private final Map transWeights;
    private final transient MarkovModel.DistributionForwarder distForwarder;

    public Alphabet emissionAlphabet() {
        return this.wm.getAlphabet();
    }

    public FiniteAlphabet stateAlphabet() {
        return this.stateAlpha;
    }

    public int heads() {
        return 1;
    }

    public MagicalState magicalState() {
        return this.magicalState;
    }

    public Distribution getWeights(State source) throws IllegalSymbolException {
        this.stateAlpha.validate(source);
        return (Distribution)this.transWeights.get(source);
    }

    public void setWeights(State source, Distribution dist) throws ChangeVetoException {
        throw new ChangeVetoException("Can't replace distribution in immutable model");
    }

    public FiniteAlphabet transitionsFrom(State from) throws IllegalSymbolException {
        FiniteAlphabet sAlpha = this.stateAlphabet();
        sAlpha.validate(from);
        return (FiniteAlphabet)this.transFrom.get(from);
    }

    public FiniteAlphabet transitionsTo(State to) throws IllegalSymbolException {
        FiniteAlphabet sAlpha = this.stateAlphabet();
        sAlpha.validate(to);
        return (FiniteAlphabet)this.transTo.get(to);
    }

    public void registerWithTrainer(ModelTrainer modelTrainer) throws BioException {
    }

    public void createTransition(State from, State to) throws ChangeVetoException {
        throw new ChangeVetoException("destroyTransition not supported by " + this.getClass());
    }

    public void destroyTransition(State from, State to) throws ChangeVetoException {
        throw new ChangeVetoException("destroyTransition not supported by " + this.getClass());
    }

    public void addState(State toAdd) throws IllegalSymbolException, ChangeVetoException {
        if (this.stateAlphabet().contains(toAdd)) {
            throw new IllegalSymbolException(toAdd, "Can't add a state to a model that already contains it");
        }
        throw new ChangeVetoException("addState not supported by " + this.getClass());
    }

    public void removeState(State toAdd) throws IllegalSymbolException, ChangeVetoException {
        this.stateAlphabet().validate(toAdd);
        throw new ChangeVetoException("removeState not supported by " + this.getClass());
    }

    public boolean containsTransition(State from, State to) throws IllegalSymbolException {
        FiniteAlphabet sAlpha = this.stateAlphabet();
        sAlpha.validate(from);
        sAlpha.validate(to);
        return this.transitionsFrom(from).contains(to);
    }

    protected int index(State s) {
        int i = 0;
        while (i < this.states.length) {
            if (s == this.states[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public WMAsMM(WeightMatrix wm) throws IllegalSymbolException {
        try {
            ChangeSupport changeSupport = this.getChangeSupport(ChangeType.UNKNOWN);
            this.distForwarder = new MarkovModel.DistributionForwarder(this, changeSupport);
            this.transFrom = new HashMap();
            this.transTo = new HashMap();
            this.transWeights = new HashMap();
            this.wm = wm;
            this.magicalState = MagicalState.getMagicalState(wm.getAlphabet(), 1);
            SimpleAlphabet sa = new SimpleAlphabet();
            sa.addSymbol(this.magicalState);
            this.stateAlpha = sa;
            this.states = new EmissionState[wm.columns()];
            int i = 0;
            while (i <= wm.columns()) {
                if (i < wm.columns()) {
                    this.states[i] = new SimpleEmissionState(i + "", Annotation.EMPTY_ANNOTATION, advance, wm.getColumn(i));
                    sa.addSymbol(this.states[i]);
                    wm.getColumn(i).addChangeListener(this.distForwarder);
                }
                MagicalState prev = i == 0 ? this.magicalState : this.states[i - 1];
                MagicalState current = i == wm.columns() ? this.magicalState : this.states[i];
                FiniteAlphabet fa = (FiniteAlphabet)prev.getMatches();
                this.transFrom.put(prev, current.getMatches());
                this.transTo.put(current, fa);
                UniformDistribution dist = new UniformDistribution(fa);
                this.transWeights.put(prev, dist);
                ++i;
            }
            sa.setName("Weight Matrix columns");
        }
        catch (ChangeVetoException cve) {
            throw new BioError(cve, "Assertion Failure: Should be able to manipulate my state alphabet.");
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Assertion Failure: Should be able to manipulate my state alphabet.");
        }
    }
}

