/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.BlockPainter;
import org.biojava.bio.gui.LogoContext;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;

public class TextBlock
implements BlockPainter {
    private Font logoFont = new Font("Tahoma", 0, 12);

    public Font getLogoFont() {
        return this.logoFont;
    }

    public void setLogoFont(Font logoFont) {
        this.logoFont = logoFont;
    }

    public void paintBlock(LogoContext ctxt, Rectangle2D block, AtomicSymbol sym) {
        Graphics2D g2 = ctxt.getGraphics();
        SymbolStyle style = ctxt.getStyle();
        Distribution dist = ctxt.getDistribution();
        SymbolTokenization toke = null;
        try {
            toke = dist.getAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioRuntimeException(ex);
        }
        FontRenderContext frc = g2.getFontRenderContext();
        try {
            GlyphVector gv = this.logoFont.createGlyphVector(frc, toke.tokenizeSymbol(sym));
            Shape outline = gv.getOutline();
            Rectangle2D oBounds = outline.getBounds2D();
            AffineTransform at = new AffineTransform();
            at.setToTranslation(block.getX(), block.getY());
            at.scale(block.getWidth() / oBounds.getWidth(), block.getHeight() / oBounds.getHeight());
            at.translate(-oBounds.getMinX(), -oBounds.getMinY());
            outline = at.createTransformedShape(outline);
            try {
                g2.setPaint(style.fillPaint(sym));
            }
            catch (IllegalSymbolException ire) {
                g2.setPaint(Color.black);
            }
            g2.fill(outline);
            try {
                g2.setPaint(style.outlinePaint(sym));
            }
            catch (IllegalSymbolException ire) {
                g2.setPaint(Color.gray);
            }
            g2.draw(outline);
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex, "Couldn't tokenize symbol");
        }
    }
}

