/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.gui.sequence.BasicFeatureRenderer;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;
import org.biojava.utils.NestedError;

public class FeatureBlockSequenceRenderer
extends AbstractChangeable
implements SequenceRenderer {
    public static ChangeType FEATURE_RENDERER = new ChangeType("The associated FeatureRenderer has changed", "org.biojava.bio.gui.sequence.FeatureBlockSequenceRenderer", "FEATURE_RENDERER", SequenceRenderContext.LAYOUT);
    public static ChangeType FEATURE_COLLAPSING = new ChangeType("Changed whether the render collapses when no features are visible", "org.biojava.bio.gui.sequence.FeatureBlockSequenceRenderer", "FEATURE_COLLAPSING", SequenceRenderContext.LAYOUT);
    private FeatureRenderer renderer;
    private boolean isCollapsing = true;
    private transient ChangeForwarder rendForwarder;

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.rendForwarder == null) {
            this.rendForwarder = new SequenceRenderer.RendererForwarder(this, cs);
            if (this.renderer != null && this.renderer instanceof Changeable) {
                Changeable c = (Changeable)((Object)this.renderer);
                c.addChangeListener(this.rendForwarder, SequenceRenderContext.REPAINT);
            }
        }
        return cs;
    }

    public FeatureBlockSequenceRenderer() {
        try {
            this.setFeatureRenderer(new BasicFeatureRenderer());
        }
        catch (ChangeVetoException cve) {
            throw new NestedError(cve, "Assertion Failure: Should have no listeners");
        }
    }

    public FeatureBlockSequenceRenderer(FeatureRenderer fRend) {
        try {
            this.setFeatureRenderer(fRend);
        }
        catch (ChangeVetoException cve) {
            throw new NestedError(cve, "Assertion Failure: Should have no listeners");
        }
    }

    public FeatureRenderer getFeatureRenderer() {
        return this.renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeatureRenderer(FeatureRenderer renderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(FEATURE_RENDERER);
            synchronized (changeSupport) {
                Changeable c;
                ChangeEvent ce = new ChangeEvent(this, FEATURE_RENDERER, this.renderer, renderer);
                cs.firePreChangeEvent(ce);
                if (this.renderer != null && this.renderer instanceof Changeable) {
                    c = (Changeable)((Object)this.renderer);
                    c.removeChangeListener(this.rendForwarder);
                }
                this.renderer = renderer;
                if (renderer instanceof Changeable) {
                    c = (Changeable)((Object)renderer);
                    c.removeChangeListener(this.rendForwarder);
                }
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.renderer = renderer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCollapsing(boolean b) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(FEATURE_COLLAPSING);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, FEATURE_COLLAPSING, new Boolean(this.isCollapsing), new Boolean(b));
                cs.firePreChangeEvent(ce);
                this.isCollapsing = b;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.isCollapsing = b;
        }
    }

    public boolean getCollapsing() {
        return this.isCollapsing;
    }

    public double getDepth(SequenceRenderContext src) {
        FeatureHolder features = src.getFeatures();
        FeatureFilter.OverlapsLocation filter = new FeatureFilter.OverlapsLocation(src.getRange());
        FeatureHolder fh = features.filter(filter, false);
        if (!this.isCollapsing || fh.countFeatures() > 0) {
            return this.renderer.getDepth(src);
        }
        return 0.0;
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        return 0.0;
    }

    public void paint(Graphics2D g, SequenceRenderContext src) {
        Iterator i = src.getFeatures().filter(new FeatureFilter.OverlapsLocation(src.getRange()), false).features();
        while (i.hasNext()) {
            Shape clip = g.getClip();
            AffineTransform at = g.getTransform();
            Feature f = (Feature)i.next();
            Location l = f.getLocation();
            this.renderer.renderFeature(g, f, src);
            g.setTransform(at);
            g.setClip(clip);
        }
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        double pos = src.getDirection() == 0 ? me.getPoint().getX() : me.getPoint().getY();
        int sMin = src.graphicsToSequence(pos);
        int sMax = src.graphicsToSequence(pos + 1.0);
        FeatureHolder hits = src.getFeatures().filter(new FeatureFilter.OverlapsLocation(new RangeLocation(sMin, sMax)), false);
        hits = this.renderer.processMouseEvent(hits, src, me);
        return new SequenceViewerEvent(this, hits, sMin, me, path);
    }
}

