/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.phred;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.DistributionTools;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.program.phred.PhredFormat;
import org.biojava.bio.program.phred.PhredSequence;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.StreamWriter;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ListTools;
import org.biojava.utils.NestedError;

public final class PhredTools {
    private static SequenceBuilderFactory _fastaBuilderFactory;

    public static final FiniteAlphabet getPhredAlphabet() {
        return (FiniteAlphabet)AlphabetManager.alphabetForName("PHRED");
    }

    public static final Symbol dnaSymbolFromPhred(Symbol phredSym) throws IllegalSymbolException {
        PhredTools.getPhredAlphabet().validate(phredSym);
        List l = ((BasisSymbol)phredSym).getSymbols();
        return (AtomicSymbol)l.get(0);
    }

    public static final IntegerAlphabet.IntegerSymbol integerSymbolFromPhred(Symbol phredSym) throws IllegalSymbolException {
        PhredTools.getPhredAlphabet().validate(phredSym);
        List l = ((BasisSymbol)phredSym).getSymbols();
        return (IntegerAlphabet.IntegerSymbol)l.get(1);
    }

    public static SymbolList createPhred(SymbolList dna, SymbolList quality) throws IllegalArgumentException, IllegalAlphabetException, IllegalSymbolException {
        if (dna.length() != quality.length()) {
            throw new IllegalArgumentException("SymbolLists must be of equal length " + dna.length() + " : " + quality.length());
        }
        if (dna.getAlphabet() != DNATools.getDNA()) {
            throw new IllegalAlphabetException("Expecting SymbolList 'dna' to use the DNA alphabet, uses " + dna.getAlphabet().getName());
        }
        IntegerAlphabet.SubIntegerAlphabet subint = IntegerAlphabet.getSubAlphabet(0, 99);
        if (quality.getAlphabet() != subint && quality.getAlphabet() != IntegerAlphabet.getInstance()) {
            throw new IllegalAlphabetException("Expecting SymbolList quality to use the " + subint.getName() + " alphabet" + "or IntegerAlphabet instead uses " + quality.getAlphabet().getName());
        }
        SimpleSymbolList sl = new SimpleSymbolList(PhredTools.getPhredAlphabet());
        int i = 1;
        while (i <= dna.length()) {
            Symbol d = dna.symbolAt(i);
            Symbol q = quality.symbolAt(i);
            try {
                sl.addSymbol(PhredTools.getPhredSymbol(d, q));
            }
            catch (ChangeVetoException e) {
                throw new NestedError(e);
            }
            ++i;
        }
        return sl;
    }

    public static final Symbol getPhredSymbol(Symbol dna, Symbol integer) throws IllegalSymbolException {
        return PhredTools.getPhredAlphabet().getSymbol(new ListTools.Doublet(dna, integer));
    }

    public static void writePhredQuality(OutputStream qual, OutputStream seq, SequenceDB db) throws IOException, BioException {
        StreamWriter qualw = new StreamWriter(qual, new PhredFormat());
        StreamWriter seqw = new StreamWriter(seq, new FastaFormat());
        HashSequenceDB qualDB = new HashSequenceDB(IDMaker.byName);
        SequenceIterator i = db.sequenceIterator();
        while (i.hasNext()) {
            Sequence p = i.nextSequence();
            if (p instanceof PhredSequence) {
                PhredSequence ps = (PhredSequence)p;
                SymbolList ql = ps.getQuality();
                try {
                    qualDB.addSequence(new SimpleSequence(ql, p.getURN(), p.getName(), p.getAnnotation()));
                    continue;
                }
                catch (ChangeVetoException cve) {
                    throw new NestedError(cve, "Cannot Add Quality Sequences to Database");
                }
            }
            throw new BioException("Expecting PhredSequence, got " + p.getClass().getName());
        }
        qualw.writeStream(qualDB.sequenceIterator());
        seqw.writeStream(db.sequenceIterator());
    }

    public static StreamReader readPhredQuality(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new PhredFormat(), PhredTools.getQualityParser(), PhredTools.getFastaBuilderFactory());
    }

    public static StreamReader readPhredSequence(BufferedReader br) {
        return (StreamReader)SeqIOTools.readFastaDNA(br);
    }

    private static SequenceBuilderFactory getFastaBuilderFactory() {
        if (_fastaBuilderFactory == null) {
            _fastaBuilderFactory = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
        }
        return _fastaBuilderFactory;
    }

    private static SymbolTokenization getQualityParser() {
        return IntegerAlphabet.getInstance().getTokenization("token");
    }

    public static double qualityFromP(double probOfError) {
        return -10.0 * (Math.log(probOfError) / Math.log(10.0));
    }

    public static double pFromQuality(double quality) {
        return Math.pow(10.0, quality / -10.0);
    }

    public static double pFromQuality(int quality) {
        return PhredTools.pFromQuality((double)quality);
    }

    public static double pFromQuality(IntegerAlphabet.IntegerSymbol quality) {
        return PhredTools.pFromQuality(quality.intValue());
    }

    public static Distribution[] phredToDistArray(PhredSequence s) {
        Distribution[] pos = new Distribution[s.length()];
        SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
        int i = 0;
        while (i < s.length()) {
            Symbol qual = s.getQualityAt(i);
            Symbol base = s.getDNAAt(i);
            double pBase = PhredTools.pFromQuality((IntegerAlphabet.IntegerSymbol)qual);
            double pOthers = (1.0 - pBase) / 3.0;
            try {
                pos[i] = DistributionFactory.DEFAULT.createDistribution(DNATools.getDNA());
                dtc.registerDistribution(pos[i]);
                Iterator iter = DNATools.getDNA().iterator();
                while (iter.hasNext()) {
                    Symbol sym = (Symbol)iter.next();
                    if (sym.equals(base)) {
                        pos[i].setWeight(sym, pBase);
                        continue;
                    }
                    pos[i].setWeight(sym, pOthers);
                }
                dtc.train();
            }
            catch (IllegalAlphabetException iae) {
                throw new NestedError(iae, "Sequence " + s.getName() + " contains an illegal alphabet");
            }
            catch (ChangeVetoException cve) {
                throw new NestedError(cve, "The Distribution has become locked");
            }
            catch (IllegalSymbolException ise) {
                throw new NestedError(ise, "Sequence " + s.getName() + " contains an illegal symbol");
            }
            ++i;
        }
        return pos;
    }

    public static Distribution[] phredAlignmentToDistArray(Alignment a) {
        List labels = a.getLabels();
        int depth = labels.size();
        Distribution[] average = new Distribution[a.length()];
        Distribution[][] matrix = new Distribution[labels.size()][];
        int y = 0;
        while (y < a.length()) {
            Iterator i = labels.iterator();
            while (i.hasNext()) {
                SymbolList sl = a.symbolListForLabel(i.next());
                matrix[y] = PhredTools.phredToDistArray((PhredSequence)sl);
            }
            average[y] = DistributionTools.average(matrix[y]);
            ++y;
        }
        return average;
    }

    static {
        try {
            ArrayList<FiniteAlphabet> l = new ArrayList<FiniteAlphabet>(2);
            l.add(DNATools.getDNA());
            l.add(IntegerAlphabet.getSubAlphabet(0, 99));
            AlphabetManager.getCrossProductAlphabet(l, "PHRED");
        }
        catch (IllegalAlphabetException iae) {
            throw new BioError(iae, "Could not create phred alphabet");
        }
    }
}

