/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.unigene;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.BioException;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.BioStoreFactory;
import org.biojava.bio.program.indexdb.IndexStore;
import org.biojava.bio.program.tagvalue.Indexer;
import org.biojava.bio.program.tagvalue.Parser;
import org.biojava.bio.program.tagvalue.ParserListener;
import org.biojava.bio.program.unigene.FlatFileUnigeneDB;
import org.biojava.bio.program.unigene.UnigeneDB;
import org.biojava.bio.program.unigene.UnigeneFactory;
import org.biojava.bio.program.unigene.UnigeneTools;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.utils.NestedException;
import org.biojava.utils.ParserException;
import org.biojava.utils.io.CountedBufferedReader;
import org.biojava.utils.io.RAF;

public class FlatFileUnigeneFactory
implements UnigeneFactory {
    private static final String DATA_INDEX = "data.index";
    private static final String LIB_INFO_INDEX = "libInfo.index";
    private static final String UNIQUE_INDEX = "unique.index";
    private static final String ALL_INDEX = "all.index";

    public boolean canAccept(URL unigeneLoc) {
        return unigeneLoc.getProtocol().equals("file");
    }

    public UnigeneDB loadUnigene(URL unigeneLoc) throws BioException {
        if (!unigeneLoc.getProtocol().equals("file")) {
            throw new BioException("Can't create unigene from non-file URL: " + unigeneLoc);
        }
        File unigeneDir = new File(unigeneLoc.getPath());
        if (!unigeneDir.exists()) {
            throw new BioException("Could not locate directory: " + unigeneDir);
        }
        if (!unigeneDir.isDirectory()) {
            throw new BioException("Expecting a directory at: " + unigeneDir);
        }
        try {
            return new FlatFileUnigeneDB(new BioStore(new File(unigeneDir, DATA_INDEX), true), new BioStore(new File(unigeneDir, LIB_INFO_INDEX), true), new BioStore(new File(unigeneDir, UNIQUE_INDEX), true), new BioStore(new File(unigeneDir, ALL_INDEX), true));
        }
        catch (IOException ioe) {
            throw new BioException(ioe, "Could not instantiate flat file unigene db");
        }
    }

    public UnigeneDB createUnigene(URL unigeneLoc) throws BioException {
        if (!unigeneLoc.getProtocol().equals("file")) {
            throw new BioException("Can't create unigene from non-file URL: " + unigeneLoc);
        }
        File unigeneDir = new File(unigeneLoc.getPath());
        if (!unigeneDir.exists()) {
            throw new BioException("Could not locate directory: " + unigeneDir);
        }
        if (!unigeneDir.isDirectory()) {
            throw new BioException("Expecting a directory at: " + unigeneDir);
        }
        try {
            this.indexAll(unigeneDir);
            this.indexUnique(unigeneDir);
            this.indexData(unigeneDir);
            this.indexLibInfo(unigeneDir);
        }
        catch (IOException ioe) {
            throw new BioException(ioe, "Failed to index data");
        }
        return this.loadUnigene(unigeneLoc);
    }

    private void indexData(File unigeneDir) throws BioException, IOException {
        File dataIndexFile = new File(unigeneDir, DATA_INDEX);
        BioStoreFactory dataBSF = new BioStoreFactory();
        dataBSF.setPrimaryKey("ID");
        dataBSF.addKey("ID", 10);
        dataBSF.setStoreLocation(dataIndexFile);
        BioStore dataStore = dataBSF.createBioStore();
        File[] dataFiles = unigeneDir.listFiles(new FileFilter(){

            public boolean accept(File pathName) {
                return pathName.getName().endsWith(".data");
            }
        });
        int i = 0;
        while (i < dataFiles.length) {
            File f = dataFiles[i];
            try {
                Indexer indexer = new Indexer(f, dataStore);
                indexer.setPrimaryKeyName("ID");
                Parser parser = new Parser();
                ParserListener pl = UnigeneTools.buildDataParser(indexer);
                while (parser.read(indexer.getReader(), pl.getParser(), pl.getListener())) {
                }
            }
            catch (ParserException pe) {
                throw new BioException(pe, "Failed to parse " + f);
            }
            ++i;
        }
        try {
            dataStore.commit();
        }
        catch (NestedException ne) {
            throw new BioException(ne);
        }
    }

    private void indexLibInfo(File unigeneDir) throws BioException, IOException {
        File liIndexFile = new File(unigeneDir, LIB_INFO_INDEX);
        BioStoreFactory liBSF = new BioStoreFactory();
        liBSF.setPrimaryKey("ID");
        liBSF.addKey("ID", 7);
        liBSF.setStoreLocation(liIndexFile);
        BioStore liStore = liBSF.createBioStore();
        File[] liFiles = unigeneDir.listFiles(new FileFilter(){

            public boolean accept(File pathName) {
                return pathName.getName().endsWith(".lib.info");
            }
        });
        int i = 0;
        while (i < liFiles.length) {
            File f = liFiles[i];
            try {
                Indexer indexer = new Indexer(f, liStore);
                indexer.setPrimaryKeyName("ID");
                Parser parser = new Parser();
                ParserListener pl = UnigeneTools.buildLibInfoParser(indexer);
                while (parser.read(indexer.getReader(), pl.getParser(), pl.getListener())) {
                }
            }
            catch (ParserException pe) {
                throw new BioException(pe, "Failed to parse " + f);
            }
            ++i;
        }
        try {
            liStore.commit();
        }
        catch (NestedException ne) {
            throw new BioException(ne);
        }
    }

    private void indexUnique(File unigeneDir) throws BioException, IOException {
        File uniqueIndex = new File(unigeneDir, UNIQUE_INDEX);
        BioStoreFactory uniqueBSF = new BioStoreFactory();
        uniqueBSF.setStoreLocation(uniqueIndex);
        uniqueBSF.setPrimaryKey("ID");
        uniqueBSF.addKey("ID", 10);
        BioStore uniqueStore = uniqueBSF.createBioStore();
        File[] uniqueFiles = unigeneDir.listFiles(new FileFilter(){

            public boolean accept(File pathName) {
                return pathName.getName().endsWith(".seq.uniq");
            }
        });
        int i = 0;
        while (i < uniqueFiles.length) {
            File f = uniqueFiles[i];
            RAF raf = new RAF(f, "r");
            FastaIndexer indexer = new FastaIndexer(raf, uniqueStore, Pattern.compile("#(\\S+)"), 1);
            FastaFormat format = new FastaFormat();
            SymbolTokenization tok = DNATools.getDNA().getTokenization("token");
            StreamReader sreader = new StreamReader(indexer.getReader(), (SequenceFormat)format, tok, (SequenceBuilderFactory)indexer);
            while (sreader.hasNext()) {
                sreader.nextSequence();
            }
            ++i;
        }
        try {
            uniqueStore.commit();
        }
        catch (NestedException ne) {
            throw new BioException(ne);
        }
    }

    private void indexAll(File unigeneDir) throws BioException, IOException {
        File allIndex = new File(unigeneDir, ALL_INDEX);
        BioStoreFactory allBSF = new BioStoreFactory();
        allBSF.setStoreLocation(allIndex);
        allBSF.setPrimaryKey("ID");
        allBSF.addKey("ID", 10);
        BioStore allStore = allBSF.createBioStore();
        File[] allFiles = unigeneDir.listFiles(new FileFilter(){

            public boolean accept(File pathName) {
                return pathName.getName().endsWith(".seq.all");
            }
        });
        Pattern pattern = Pattern.compile("/gb=(\\S+)");
        int i = 0;
        while (i < allFiles.length) {
            File f = allFiles[i];
            RAF raf = new RAF(f, "r");
            CountedBufferedReader reader = new CountedBufferedReader(new FileReader(f));
            long offset = -1L;
            String id = null;
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("#")) {
                    long nof = reader.getFilePointer();
                    if (id != null) {
                        allStore.writeRecord(raf, offset, (int)(nof - offset), id, Collections.EMPTY_MAP);
                    }
                    Matcher matcher = pattern.matcher(line);
                    matcher.find();
                    id = matcher.group(1);
                    offset = nof;
                }
                line = reader.readLine();
            }
            ++i;
        }
        try {
            allStore.commit();
        }
        catch (NestedException ne) {
            throw new BioException(ne);
        }
    }

    private static class FastaIndexer
    implements SequenceBuilderFactory {
        private final Map map = new HashMap();
        private final RAF raf;
        private final IndexStore store;
        private final CountedBufferedReader reader;
        private final Pattern idPattern;
        private final int idGroup;

        public FastaIndexer(RAF raf, IndexStore store, Pattern idPattern, int idGroup) throws IOException {
            this.raf = raf;
            this.store = store;
            this.idPattern = idPattern;
            this.idGroup = idGroup;
            this.reader = new CountedBufferedReader(new FileReader(raf.getFile()));
        }

        public CountedBufferedReader getReader() {
            return this.reader;
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new SeqIOIndexer();
        }

        class SeqIOIndexer
        extends SeqIOAdapter
        implements SequenceBuilder {
            long offset = 0L;
            String id;

            SeqIOIndexer() {
            }

            public void startSequence() {
                this.id = null;
                this.offset = FastaIndexer.this.reader.getFilePointer();
            }

            public void addSequenceProperty(Object key, Object value) {
                if (key.equals("description_line")) {
                    String line = (String)value;
                    Matcher m = FastaIndexer.this.idPattern.matcher(line);
                    m.find();
                    this.id = m.group(FastaIndexer.this.idGroup);
                }
            }

            public void endSequence() {
                long nof = FastaIndexer.this.reader.getFilePointer();
                FastaIndexer.this.store.writeRecord(FastaIndexer.this.raf, this.offset, (int)(nof - this.offset), this.id, FastaIndexer.this.map);
                this.offset = nof;
            }

            public Sequence makeSequence() {
                return null;
            }
        }
    }
}

