/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.ArrayList;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.CircularView;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public final class KnuthMorrisPrattSearch {
    private int[] kmpNext;
    private SymbolList pattern;

    public KnuthMorrisPrattSearch(SymbolList pattern) {
        Alphabet alpha = pattern.getAlphabet();
        ArrayList<Symbol> rList = new ArrayList<Symbol>(pattern.toList());
        rList.add(alpha.getGapSymbol());
        try {
            this.pattern = new SimpleSymbolList(alpha, rList);
        }
        catch (Exception e) {
            throw new BioError(e, "Couldn't make KMP pattern");
        }
        this.kmpNext = new int[this.pattern.length()];
        this.compilePattern();
    }

    /*
     * Unable to fully structure code
     */
    private void compilePattern() {
        k = this.pattern.length() - 1;
        i = 0;
        this.kmpNext[0] = -1;
        j = -1;
        ** GOTO lbl10
        {
            j = this.kmpNext[j];
            do {
                if (j > -1 && this.pattern.symbolAt(i + 1) != this.pattern.symbolAt(j + 1)) continue block0;
                this.kmpNext[i] = this.pattern.symbolAt(++i + 1) == this.pattern.symbolAt(++j + 1) ? this.kmpNext[j] : j;
lbl10:
                // 2 sources

            } while (i < k);
        }
    }

    public int[] findMatches(SymbolList text) {
        ArrayList<Integer> matches = new ArrayList<Integer>();
        int i = 0;
        int j = 0;
        int m = this.pattern.length() - 1;
        int n = text instanceof CircularView ? text.length() + this.pattern.length() - 1 : text.length();
        while (j < n) {
            Symbol sym = text.symbolAt(j + 1);
            while (i > -1 && this.pattern.symbolAt(i + 1) != sym) {
                i = this.kmpNext[i];
            }
            ++j;
            if (++i < m) continue;
            matches.add(new Integer(j - i + 1));
            i = this.kmpNext[i];
        }
        int[] mat = new int[matches.size()];
        int x = 0;
        while (x < mat.length) {
            mat[x] = (Integer)matches.get(x);
            ++x;
        }
        return mat;
    }

    protected int[] getKmpNextTable() {
        return this.kmpNext;
    }

    public SymbolList getPattern() {
        return this.pattern;
    }

    public static void main(String[] args) throws Exception {
        SymbolList pattern = DNATools.createDNA("gcagagag");
        SymbolList pattern2 = DNATools.createDNA("agag");
        SymbolList text = DNATools.createDNA("gcatcgcagagagtatacagtacg");
        KnuthMorrisPrattSearch kmp1 = new KnuthMorrisPrattSearch(pattern);
        int[] table = kmp1.getKmpNextTable();
        System.out.println(pattern.seqString());
        int i = 0;
        while (i < table.length) {
            System.out.print(table[i] + " ");
            ++i;
        }
        System.out.println("");
        int[] matches = kmp1.findMatches(text);
        System.out.print("Matches at: ");
        int i2 = 0;
        while (i2 < matches.length) {
            System.out.print(matches[i2] + " ");
            ++i2;
        }
        System.out.println("\n");
        kmp1 = new KnuthMorrisPrattSearch(pattern2);
        table = kmp1.getKmpNextTable();
        System.out.println(pattern2.seqString());
        int i3 = 0;
        while (i3 < table.length) {
            System.out.print(table[i3] + " ");
            ++i3;
        }
        System.out.println("");
        matches = kmp1.findMatches(text);
        System.out.print("Matches at: ");
        int i4 = 0;
        while (i4 < matches.length) {
            System.out.print(matches[i4] + " ");
            ++i4;
        }
        System.out.println("\n");
    }
}

