/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.distributed;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.MergeAnnotation;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.distributed.DistComponentFeature;
import org.biojava.bio.seq.distributed.DistributedSequence;
import org.biojava.utils.ChangeVetoException;

class DistProjectedFeatureHolder
extends ProjectedFeatureHolder {
    private Annotation annotation;
    private Map componentFeatureCache = new HashMap();

    public DistProjectedFeatureHolder(FeatureHolder fh, FeatureHolder parent, Annotation annotation) {
        super(fh, parent, 0, false);
        this.annotation = annotation;
    }

    public Feature projectFeature(Feature f) {
        if (f instanceof ComponentFeature && this.getParent() instanceof DistributedSequence) {
            ComponentFeature pcf = (ComponentFeature)this.componentFeatureCache.get(f);
            if (pcf == null) {
                ComponentFeature.Template cft = (ComponentFeature.Template)((ComponentFeature)f).makeTemplate();
                if (cft.componentSequenceName == null) {
                    cft.componentSequenceName = cft.componentSequence.getName();
                }
                if (cft.componentSequenceName == null) {
                    throw new NullPointerException("Can't get component sequence name");
                }
                cft.componentSequence = null;
                try {
                    pcf = new DistComponentFeature((DistributedSequence)this.getParent(), cft);
                }
                catch (Exception ex) {
                    throw new BioRuntimeException(ex, "Error instantiating DistComponentFeature for: " + f);
                }
                this.componentFeatureCache.put(f, pcf);
            }
            return pcf;
        }
        return super.projectFeature(f);
    }

    public Annotation getAnnotation(Feature f) {
        if (this.annotation != null) {
            try {
                MergeAnnotation ma = new MergeAnnotation();
                ma.addAnnotation(f.getAnnotation());
                ma.addAnnotation(this.annotation);
                return ma;
            }
            catch (ChangeVetoException cve) {
                throw new BioError(cve);
            }
        }
        return f.getAnnotation();
    }
}

