/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Frame;
import org.biojava.bio.seq.FramedFeature;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleStrandedFeature;
import org.biojava.bio.symbol.IllegalAlphabetException;

public class SimpleFramedFeature
extends SimpleStrandedFeature
implements FramedFeature,
Frame {
    private FramedFeature.ReadingFrame readingFrame = FramedFeature.Template.readingFrame;

    public SimpleFramedFeature(Sequence sourceSeq, FeatureHolder parent, FramedFeature.Template template) throws IllegalAlphabetException {
        super(sourceSeq, parent, template);
        if (sourceSeq.getAlphabet() == RNATools.getRNA() && template.strand == StrandedFeature.NEGATIVE) {
            throw new IllegalAlphabetException("Cannot create a FramedFeature on the negative strand of an RNA");
        }
        if (sourceSeq.getAlphabet() != DNATools.getDNA()) {
            throw new IllegalAlphabetException("Cannot create a FramedFeature on a sequence of type " + sourceSeq.getAlphabet().getName());
        }
    }

    public FramedFeature.ReadingFrame getReadingFrame() {
        return this.readingFrame;
    }

    public int getFrame() {
        return this.readingFrame.getFrame();
    }

    public Feature.Template makeTemplate() {
        FramedFeature.Template ft = new FramedFeature.Template();
        this.fillTemplate(ft);
        return ft;
    }

    protected void fillTemplate(FramedFeature.Template ft) {
        super.fillTemplate(ft);
        FramedFeature.Template.readingFrame = this.getReadingFrame();
    }

    public String toString() {
        return super.toString() + " " + this.getStrand().getToken() + "" + this.getReadingFrame().getFrame();
    }
}

