/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.RemoteFeature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.BetweenLocation;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.FuzzyPointLocation;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class AbstractGenEmblFileFormer {
    private static final String FEATURE_DATA_FILE = "org/biojava/bio/seq/io/FeatureQualifier.xml";
    private static final Map FEATURE_DATA = new HashMap();
    private static final Map QUALIFIER_DATA = new HashMap();
    static final int FIRST = 0;
    static final int OVERWIDE = 1;
    static final int NOFIT = 2;
    static final int FIT = 3;
    static final int RANGE = 0;
    static final int POINT = 1;
    static final int FUZZY_RANGE = 2;
    static final int FUZZY_POINT = 3;
    static final int BETWEEN_LOCATION = 4;
    String nl = System.getProperty("line.separator");
    SymbolTokenization dnaTokenization;
    AlphabetIndex dnaIndex = AlphabetManager.getAlphabetIndex(DNATools.getDNA());
    int aCount;
    int cCount;
    int gCount;
    int tCount;
    int oCount;
    Symbol a = DNATools.a();
    Symbol c = DNATools.c();
    Symbol g = DNATools.g();
    Symbol t = DNATools.t();
    static /* synthetic */ Class class$org$biojava$bio$symbol$PointLocation;
    static /* synthetic */ Class class$org$biojava$bio$symbol$FuzzyLocation;
    static /* synthetic */ Class class$org$biojava$bio$symbol$FuzzyPointLocation;
    static /* synthetic */ Class class$org$biojava$bio$symbol$BetweenLocation;
    static /* synthetic */ Class class$org$biojava$bio$seq$io$EmblFileFormer;

    AbstractGenEmblFileFormer() {
        try {
            this.dnaTokenization = DNATools.getDNA().getTokenization("token");
        }
        catch (Exception e) {
            throw new BioError(e, "Couldn't initialize tokenizer for the DNA alphabet");
        }
    }

    StringBuffer formatSequenceProperty(StringBuffer sb, String text, String leader, int wrapWidth) {
        BreakIterator boundary = BreakIterator.getLineInstance();
        boundary.setText(text);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = 0;
        sb.append(leader);
        while (end != -1) {
            String word = text.substring(start, end);
            if ((lineLength += word.length()) >= wrapWidth) {
                sb.append(this.nl);
                sb.append(leader);
                lineLength = word.length();
            }
            sb.append(word);
            start = end;
            end = boundary.next();
        }
        return sb;
    }

    StringBuffer formatQualifierBlock(StringBuffer sb, String text, String leader, int wrapWidth) {
        int tokenType = 0;
        int position = leader.length();
        sb.append(leader);
        StringTokenizer t = new StringTokenizer(text);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            String separator = "";
            int tokenLen = s.length();
            if (tokenType != 0) {
                separator = " ";
                tokenType = tokenLen + 1 > wrapWidth ? 1 : (position + tokenLen + 1 > wrapWidth ? 2 : 3);
            }
            switch (tokenType) {
                case 0: {
                    if (position + tokenLen <= wrapWidth) {
                        sb.append(s);
                        position += s.length();
                        tokenType = 3;
                        break;
                    }
                    separator = " ";
                }
                case 1: {
                    int i = 0;
                    while (i < tokenLen) {
                        if (position == wrapWidth) {
                            sb.append(this.nl);
                            sb.append(leader);
                            position = leader.length();
                        }
                        sb.append(s.charAt(i));
                        ++position;
                        ++i;
                    }
                    position = tokenLen % wrapWidth;
                    break;
                }
                case 2: {
                    sb.append(this.nl);
                    sb.append(leader);
                    sb.append(s);
                    position = tokenLen + leader.length();
                    break;
                }
                case 3: {
                    sb.append(separator);
                    sb.append(s);
                    position += tokenLen + 1;
                    break;
                }
            }
        }
        return sb;
    }

    StringBuffer formatQualifier(StringBuffer sb, Object key, Object value) {
        sb.append('/');
        sb.append(key);
        String form = "quoted";
        if (QUALIFIER_DATA.containsKey(key)) {
            form = (String)((Map)QUALIFIER_DATA.get(key)).get("form");
        }
        if (form.equals("quoted")) {
            sb.append("=\"");
            sb.append(value);
            sb.append("\"");
        } else if (form.equals("bare")) {
            sb.append('=');
            sb.append(value);
        } else if (form.equals("paren")) {
            sb.append('(');
            sb.append(value);
            sb.append(')');
        } else if (!form.equals("empty")) {
            sb.append('=');
            sb.append(value);
        }
        return sb;
    }

    StringBuffer formatTokenBlock(StringBuffer sb, Symbol[] syms, int blockSize, SymbolTokenization tokenization) throws IllegalSymbolException {
        int i = 0;
        while (i < syms.length) {
            sb.append(tokenization.tokenizeSymbol(syms[i]));
            if ((i + 1) % blockSize == 0) {
                sb.append(' ');
            }
            ++i;
        }
        return sb;
    }

    public String formatLocation(Feature theFeature) {
        StringBuffer tempBuffer;
        Map dat;
        String formattedLocation = null;
        StrandedFeature.Strand featureStrand = StrandedFeature.POSITIVE;
        String joinType = "join";
        Annotation ann = theFeature.getAnnotation();
        if (ann.containsProperty("internal_data") && (dat = (Map)ann.getProperty("internal_data")).containsKey("JoinType")) {
            joinType = (String)dat.get("JoinType");
        }
        if (theFeature instanceof RemoteFeature) {
            tempBuffer = new StringBuffer();
            List regionList = ((RemoteFeature)theFeature).getRegions();
            if (regionList.size() > 1) {
                tempBuffer.append(joinType);
                tempBuffer.append('(');
            }
            ListIterator tempIterator = regionList.listIterator();
            while (tempIterator.hasNext()) {
                RemoteFeature.Region tempRegion = (RemoteFeature.Region)tempIterator.next();
                if (tempRegion.getSeqID() != null) {
                    tempBuffer.append(tempRegion.getSeqID());
                    tempBuffer.append(':');
                }
                String tempLocation = null;
                if (theFeature instanceof StrandedFeature) {
                    featureStrand = ((StrandedFeature)theFeature).getStrand();
                }
                tempLocation = this.formatLocation(tempRegion.getLocation(), featureStrand);
                tempBuffer.append(tempLocation);
                if (!tempIterator.hasNext()) continue;
                tempBuffer.append(',');
            }
            if (regionList.size() > 1) {
                tempBuffer.append(')');
            }
            formattedLocation = tempBuffer.substring(0);
        } else {
            if (theFeature instanceof StrandedFeature) {
                featureStrand = ((StrandedFeature)theFeature).getStrand();
            }
            tempBuffer = new StringBuffer();
            formattedLocation = this.formatLocationBlock(tempBuffer, theFeature.getLocation(), featureStrand.getValue(), "", Integer.MAX_VALUE, joinType).toString();
        }
        return formattedLocation;
    }

    public String formatLocation(Location loc, StrandedFeature.Strand strand) {
        StringBuffer sb = this.formatLocationBlock(new StringBuffer(), loc, strand.getValue(), "", Integer.MAX_VALUE, "join");
        return sb.substring(0);
    }

    public StringBuffer formatLocation(StringBuffer sb, Location loc, StrandedFeature.Strand strand) {
        return this.formatLocationBlock(sb, loc, strand.getValue(), "", Integer.MAX_VALUE, "join");
    }

    StringBuffer formatLocationBlock(StringBuffer sb, Location loc, int strand, String leader, int wrapWidth) {
        return this.formatLocationBlock(sb, loc, strand, leader, wrapWidth, "join");
    }

    StringBuffer formatLocationBlock(StringBuffer sb, Location loc, int strand, String leader, int wrapWidth, String joinType) {
        int position = leader.length();
        boolean join = false;
        boolean complement = false;
        ArrayList locs = new ArrayList();
        Iterator li = loc.blockIterator();
        while (li.hasNext()) {
            locs.add(li.next());
        }
        Collections.sort(locs, Location.naturalOrder);
        if (!loc.isContiguous()) {
            join = true;
            sb.append(joinType);
            sb.append('(');
            position += 5;
        }
        if (strand == -1) {
            Collections.reverse(locs);
            complement = true;
        }
        int locType = 0;
        int diff = 0;
        Iterator li2 = locs.iterator();
        while (li2.hasNext()) {
            int post;
            Location thisLoc = (Location)li2.next();
            int pre = sb.length();
            locType = (class$org$biojava$bio$symbol$PointLocation == null ? AbstractGenEmblFileFormer.class$("org.biojava.bio.symbol.PointLocation") : class$org$biojava$bio$symbol$PointLocation).isInstance(thisLoc) ? 1 : ((class$org$biojava$bio$symbol$FuzzyLocation == null ? AbstractGenEmblFileFormer.class$("org.biojava.bio.symbol.FuzzyLocation") : class$org$biojava$bio$symbol$FuzzyLocation).isInstance(thisLoc) ? 2 : ((class$org$biojava$bio$symbol$FuzzyPointLocation == null ? AbstractGenEmblFileFormer.class$("org.biojava.bio.symbol.FuzzyPointLocation") : class$org$biojava$bio$symbol$FuzzyPointLocation).isInstance(thisLoc) ? 3 : ((class$org$biojava$bio$symbol$BetweenLocation == null ? AbstractGenEmblFileFormer.class$("org.biojava.bio.symbol.BetweenLocation") : class$org$biojava$bio$symbol$BetweenLocation).isInstance(thisLoc) ? 4 : 0)));
            StringBuffer lb = new StringBuffer();
            switch (locType) {
                case 1: {
                    PointLocation pl = (PointLocation)thisLoc;
                    sb.append(complement ? this.toComplement(this.formatPoint(lb, pl).substring(0)) : this.formatPoint(lb, pl).substring(0));
                    break;
                }
                case 2: {
                    FuzzyLocation fl = (FuzzyLocation)thisLoc;
                    sb.append(complement ? this.toComplement(this.formatFuzzyRange(lb, fl).substring(0)) : this.formatFuzzyRange(lb, fl).substring(0));
                    break;
                }
                case 3: {
                    FuzzyPointLocation fpl = (FuzzyPointLocation)thisLoc;
                    sb.append(complement ? this.toComplement(this.formatFuzzyPoint(lb, fpl).substring(0)) : this.formatFuzzyPoint(lb, fpl).substring(0));
                    break;
                }
                case 0: {
                    RangeLocation rl = (RangeLocation)thisLoc;
                    sb.append(complement ? this.toComplement(this.formatRange(lb, rl).substring(0)) : this.formatRange(lb, rl).substring(0));
                    break;
                }
                case 4: {
                    BetweenLocation tempLocation = (BetweenLocation)thisLoc;
                    String formattedLocation = this.formatBetween(lb, tempLocation).toString();
                    if (complement) {
                        formattedLocation = this.toComplement(formattedLocation);
                    }
                    sb.append(formattedLocation);
                    break;
                }
            }
            if (locs.indexOf(thisLoc) + 1 < locs.size()) {
                sb.append(',');
            }
            if (position + (diff = (post = sb.length()) - pre) > wrapWidth) {
                sb.insert(sb.length() - diff, this.nl + leader);
                position = leader.length() + diff;
                continue;
            }
            position += diff;
        }
        if (join) {
            sb.append(')');
            if (position + 1 > wrapWidth) {
                sb.insert(sb.length() - diff, this.nl + leader);
                ++position;
                ++diff;
            }
        }
        return sb;
    }

    private StringBuffer formatFuzzyRange(StringBuffer sb, FuzzyLocation fl) {
        if (!fl.hasBoundedMin()) {
            sb.append('<');
            sb.append(fl.getMin());
        } else if (fl.getOuterMin() != fl.getInnerMin()) {
            sb.append('(');
            sb.append(fl.getOuterMin());
            sb.append('.');
            sb.append(fl.getInnerMin());
            sb.append(')');
        } else {
            sb.append(fl.getMin());
        }
        sb.append("..");
        if (!fl.hasBoundedMax()) {
            sb.append('>');
            sb.append(fl.getMax());
        } else if (fl.getInnerMax() != fl.getOuterMax()) {
            sb.append('(');
            sb.append(fl.getInnerMax());
            sb.append('.');
            sb.append(fl.getOuterMax());
            sb.append(')');
        } else {
            sb.append(fl.getMax());
        }
        return sb;
    }

    private StringBuffer formatFuzzyPoint(StringBuffer sb, FuzzyPointLocation fpl) {
        if (!fpl.hasBoundedMin()) {
            sb.append('<');
            sb.append(fpl.getMax());
        } else if (!fpl.hasBoundedMax()) {
            sb.append('>');
            sb.append(fpl.getMin());
        } else {
            sb.append('(');
            sb.append(fpl.getMin());
            sb.append('.');
            sb.append(fpl.getMax());
            sb.append(')');
        }
        return sb;
    }

    private StringBuffer formatRange(StringBuffer sb, RangeLocation rl) {
        sb.append(rl.getMin());
        sb.append("..");
        sb.append(rl.getMax());
        return sb;
    }

    private StringBuffer formatPoint(StringBuffer sb, PointLocation pl) {
        sb.append(Integer.toString(pl.getMin()));
        return sb;
    }

    private StringBuffer formatBetween(StringBuffer sb, BetweenLocation theLocation) {
        sb.append(theLocation.getMin());
        sb.append('^');
        sb.append(theLocation.getMax());
        return sb;
    }

    private String toComplement(String value) {
        return "complement(" + value + ")";
    }

    static void loadFeatureData(String featureDataFile, Map featureData, Map qualifierData) {
        try {
            InputStream featureDataStream = (class$org$biojava$bio$seq$io$EmblFileFormer == null ? (class$org$biojava$bio$seq$io$EmblFileFormer = AbstractGenEmblFileFormer.class$("org.biojava.bio.seq.io.EmblFileFormer")) : class$org$biojava$bio$seq$io$EmblFileFormer).getClassLoader().getResourceAsStream(featureDataFile);
            if (featureDataStream == null) {
                throw new BioError("Failed to find resource: " + featureDataFile);
            }
            InputSource is = new InputSource(featureDataStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(is);
            NodeList featureNodes = doc.getDocumentElement().getChildNodes();
            int fNodeCount = featureNodes.getLength();
            int i = 0;
            while (i < fNodeCount) {
                Node featureNode = featureNodes.item(i);
                if (featureNode instanceof Element) {
                    Element feature = (Element)featureNode;
                    String fNodeName = feature.getNodeName();
                    if (fNodeName.equals("feature")) {
                        String featureKey = feature.getAttribute("key");
                        NodeList qualifierNodes = feature.getChildNodes();
                        int qNodeCount = qualifierNodes.getLength();
                        int j = 0;
                        while (j < qNodeCount) {
                            Element qualifier;
                            String qNodeName;
                            Node qualifierNode = qualifierNodes.item(j);
                            if (qualifierNode instanceof Element && (qNodeName = (qualifier = (Element)qualifierNode).getNodeName()).equals("qualifier")) {
                                HashMap<String, Object> qData = new HashMap<String, Object>();
                                qData.put("form", qualifier.getAttribute("form"));
                                qData.put("mandatory", new Boolean(qualifier.getAttribute("mandatory")));
                                qualifierData.put(qualifier.getAttribute("name"), qData);
                            }
                            ++j;
                        }
                        featureData.put(featureKey, qualifierData.keySet());
                    }
                    featureDataStream.close();
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (BioError be) {
            be.printStackTrace();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AbstractGenEmblFileFormer.loadFeatureData(FEATURE_DATA_FILE, FEATURE_DATA, QUALIFIER_DATA);
    }
}

