/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.regexp.RE;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.MSFAlignmentFormat;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Symbol;

public class SeqAlignReadWrite {
    public static final int FASTADNA = 1;
    public static final int FASTAPROTEIN = 2;
    public static final int EMBL = 3;
    public static final int GENBANK = 4;
    public static final int SWISSPROT = 5;
    public static final int GENPEPT = 6;
    public static final int MSFDNA = 7;
    public static final int FASTA = 8;
    public static final int FASTAALIGN = 9;
    public static final int MSFPROTEIN = 10;

    public static int guessFileType(String fileName) throws Exception {
        if (new RE(".*\\u002eem.*").match(fileName)) {
            return 3;
        }
        if (new RE(".*\\u002egb.*").match(fileName)) {
            return 4;
        }
        if (new RE(".*\\u002esp.*").match(fileName)) {
            return 5;
        }
        if (new RE(".*\\u002egp.*").match(fileName)) {
            return 6;
        }
        if (new RE(".*\\u002efa.*").match(fileName)) {
            return SeqAlignReadWrite.guessFastaType(fileName);
        }
        if (new RE(".*\\u002emsf.*").match(fileName)) {
            return SeqAlignReadWrite.guessMsfType(fileName);
        }
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String line1 = br.readLine();
        String line2 = br.readLine();
        if (line1.startsWith(">")) {
            return SeqAlignReadWrite.guessFastaType(fileName);
        }
        if (line1.startsWith("PileUp")) {
            return SeqAlignReadWrite.guessMsfType(fileName);
        }
        if (line1.startsWith("!!AA_MULTIPLE_ALIGNMENT")) {
            return 10;
        }
        if (line1.startsWith("!!NA_MULTIPLE_ALIGNMENT")) {
            return 7;
        }
        if (line1.startsWith("ID")) {
            int i = 0;
            while (i < line1.length()) {
                if (Character.toUpperCase(line1.charAt(i)) == 'P' && Character.toUpperCase(line1.charAt(i + 1)) == 'R' && Character.toUpperCase(line1.charAt(i + 2)) == 'T') {
                    return 5;
                }
                ++i;
            }
            return 3;
        }
        if (line1.toUpperCase().startsWith("LOCUS")) {
            int i = 0;
            while (i < line1.length()) {
                if (Character.toUpperCase(line1.charAt(i)) == 'A' && Character.toUpperCase(line1.charAt(i + 1)) == 'A') {
                    return 6;
                }
                ++i;
            }
            return 4;
        }
        if (line1.length() >= 45 && line1.substring(19, 45).equalsIgnoreCase("GENETIC SEQUENCE DATA BANK")) {
            return SeqAlignReadWrite.guessGenType(fileName);
        }
        System.out.println("guessFileType -- Could not guess file type.");
        return 0;
    }

    private static int guessFastaType(String fileName) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String line = br.readLine();
        line = br.readLine();
        int i = 0;
        while (i < line.length()) {
            if (Character.toUpperCase(line.charAt(i)) == 'F' || Character.toUpperCase(line.charAt(i)) == 'L' || Character.toUpperCase(line.charAt(i)) == 'I' || Character.toUpperCase(line.charAt(i)) == 'P' || Character.toUpperCase(line.charAt(i)) == 'Q' || Character.toUpperCase(line.charAt(i)) == 'E') {
                return 2;
            }
            ++i;
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private static int guessMsfType(String fileName) throws Exception {
        br = new BufferedReader(new FileReader(fileName));
        line = br.readLine();
        if (line.startsWith("!!NA_MULTIPLE_ALIGNMENT")) {
            return 7;
        }
        if (!line.startsWith("!!AA_MULTIPLE_ALIGNMENT")) ** GOTO lbl8
        return 10;
lbl-1000:
        // 1 sources

        {
            line = br.readLine();
lbl8:
            // 2 sources

            ** while (line.indexOf((String)"Type: ") == -1)
        }
lbl9:
        // 1 sources

        typeIndex = line.indexOf("Type: ") + 6;
        if (line.startsWith("N")) {
            return 7;
        }
        if (line.startsWith("P")) {
            return 10;
        }
        System.out.println("guessFileType -- Could not guess file type.");
        return 0;
    }

    private static int guessGenType(String fileName) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String line = br.readLine();
        while (line.indexOf("LOCUS") == -1) {
            line = br.readLine();
        }
        int i = 0;
        while (i < line.length()) {
            if (Character.toUpperCase(line.charAt(i)) == 'A' && Character.toUpperCase(line.charAt(i + 1)) == 'A') {
                return 6;
            }
            ++i;
        }
        return 4;
    }

    public static Object fileToBiojava(int fileType, BufferedReader br) throws Exception {
        switch (fileType) {
            case 7: 
            case 9: 
            case 10: {
                return SeqAlignReadWrite.fileToAlign(fileType, br);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return SeqAlignReadWrite.fileToSeq(fileType, br);
            }
        }
        System.out.println("fileToBiojava -- File type not recognized.");
        System.exit(0);
        return null;
    }

    private static Alignment fileToAlign(int fileType, BufferedReader br) throws Exception {
        switch (fileType) {
            case 7: 
            case 10: {
                return new MSFAlignmentFormat().read(br);
            }
            case 9: {
                return null;
            }
        }
        System.out.println("fileToAlign -- File type not recognized.");
        System.exit(0);
        return null;
    }

    private static SequenceIterator fileToSeq(int fileType, BufferedReader br) {
        switch (fileType) {
            case 1: {
                return SeqIOTools.readFastaDNA(br);
            }
            case 2: {
                return SeqIOTools.readFastaProtein(br);
            }
            case 3: {
                return SeqIOTools.readEmbl(br);
            }
            case 4: {
                return SeqIOTools.readGenbank(br);
            }
            case 5: {
                return SeqIOTools.readSwissprot(br);
            }
            case 6: {
                return SeqIOTools.readGenpept(br);
            }
        }
        System.out.println("fileToSeq -- File type not recognized.");
        System.exit(0);
        return null;
    }

    public static void biojavaToFile(int fileType, OutputStream os, Object biojava) throws Exception {
        switch (fileType) {
            case 7: 
            case 9: 
            case 10: {
                SeqAlignReadWrite.alignToFile(fileType, os, (Alignment)biojava);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                SeqAlignReadWrite.seqToFile(fileType, os, (SequenceIterator)biojava);
                break;
            }
            default: {
                System.out.println("biojavaToFile -- File type not recognized.");
                System.exit(0);
            }
        }
    }

    private static void alignToFile(int fileType, OutputStream os, Alignment align) throws Exception {
        switch (fileType) {
            case 7: {
                new MSFAlignmentFormat().writeDna(os, align);
                break;
            }
            case 10: {
                new MSFAlignmentFormat().writeProtein(os, align);
                break;
            }
            case 9: {
                break;
            }
            default: {
                System.out.println("alignToFile -- File type not recognized.");
                System.exit(0);
            }
        }
    }

    private static void seqToFile(int fileType, OutputStream os, SequenceIterator seq) throws IOException, BioException {
        switch (fileType) {
            case 1: 
            case 2: 
            case 8: {
                SeqIOTools.writeFasta(os, seq);
                break;
            }
            case 3: {
                SeqIOTools.writeEmbl(os, seq);
                break;
            }
            case 5: {
                SeqIOTools.writeSwissprot(os, seq);
                break;
            }
            case 4: {
                SeqIOTools.writeGenbank(os, seq);
                break;
            }
            case 6: {
                SeqIOTools.writeGenpept(os, seq);
                break;
            }
            default: {
                System.out.println("seqToFile -- File type not recognized.");
                System.exit(0);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String[] files = new String[]{"U:/parsing_testcases/msf/alignx_export.msf", "U:/parsing_testcases/msf/alignx_export_jalview.msf", "U:/parsing_testcases/msf/clustalw.msf", "U:/parsing_testcases/msf/megalign_export.msf", "U:/parsing_testcases/msf/egcyfp-blahblahblah.msf.txt"};
        int[] outputFileTypes = new int[]{2, 5, 6};
        String[] outputFileNames = new String[]{".fasta.txt", ".sp.txt", ".gp.txt"};
        int ift = 0;
        while (ift < 5) {
            Iterator iter = DNATools.getDNA().iterator();
            SymbolTokenization toke = DNATools.getDNA().getTokenization("token");
            while (iter.hasNext()) {
                Object sym = iter.next();
                System.out.println(toke.tokenizeSymbol((Symbol)sym) + " " + sym);
            }
            System.out.println("File: " + files[ift]);
            MSFAlignmentFormat msfaf = new MSFAlignmentFormat();
            BufferedReader br3 = new BufferedReader(new FileReader(files[ift]));
            System.out.println(br3.readLine());
            br3 = new BufferedReader(new FileReader(files[ift]));
            Alignment align = msfaf.read(br3);
            System.out.println(align.getLabels().get(1).toString());
            FileOutputStream os2 = new FileOutputStream(files[ift] + "test.txt");
            msfaf.writeProtein(os2, align);
            ++ift;
        }
    }
}

