/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;
import org.biojava.bio.seq.io.SwissprotFeatureTableParser;
import org.biojava.utils.ParseErrorEvent;
import org.biojava.utils.ParseErrorListener;
import org.biojava.utils.ParseErrorSource;

public class SwissprotProcessor
extends SequenceBuilderFilter
implements ParseErrorSource {
    public static final String PROPERTY_SWISSPROT_ACCESSIONS = "swissprot.accessions";
    public static final String PROPERTY_SWISSPROT_COMMENT = "swissprot.comment";
    public static final String PROPERTY_SWISSPROT_FEATUREATTRIBUTE = "swissprot.featureattribute";
    private boolean mBadFeature = false;
    private Vector mListeners = new Vector();
    private SwissprotFeatureTableParser features;
    private static HashSet featureKeys = null;
    private List accessions = new ArrayList();

    public SwissprotProcessor(SequenceBuilder delegate, String theSource) {
        super(delegate);
        this.features = new SwissprotFeatureTableParser(this, theSource);
    }

    public SwissprotProcessor(SequenceBuilder delegate) {
        super(delegate);
        this.features = new SwissprotFeatureTableParser(this, "SWISSPROT");
    }

    public void endSequence() throws ParseException {
        if (this.accessions.size() > 0) {
            String id = (String)this.accessions.get(0);
            this.getDelegate().setName(id);
            this.getDelegate().setURI("urn:sequence/swissprot:" + id);
            this.getDelegate().addSequenceProperty(PROPERTY_SWISSPROT_ACCESSIONS, this.accessions);
            this.accessions = new ArrayList();
        }
        this.getDelegate().endSequence();
    }

    public void addSequenceProperty(Object key, Object value) throws ParseException {
        block9: {
            try {
                if (this.mBadFeature) {
                    String featureLine = value.toString();
                    if (!key.equals("FT") || featureLine.charAt(0) == ' ') break block9;
                    this.mBadFeature = false;
                    this.features.startFeature(featureLine.substring(0, 8).trim());
                    this.features.featureData(featureLine.substring(9));
                    break block9;
                }
                if (this.features.inFeature() && !key.equals("FT")) {
                    this.features.endFeature();
                }
                if (key.equals("FT")) {
                    String featureLine = value.toString();
                    if (featureLine.charAt(0) != ' ') {
                        if (this.features.inFeature()) {
                            this.features.endFeature();
                        }
                        this.features.startFeature(featureLine.substring(0, 8).trim());
                    }
                    this.features.featureData(featureLine.substring(9));
                    break block9;
                }
                this.getDelegate().addSequenceProperty(key, value);
                if (!key.equals("AC")) break block9;
                String acc = value.toString();
                StringTokenizer toke = new StringTokenizer(acc, "; ");
                while (toke.hasMoreTokens()) {
                    this.accessions.add(toke.nextToken());
                }
            }
            catch (BioException ex) {
                this.mBadFeature = true;
                ParseErrorEvent offendingLineEvent = new ParseErrorEvent(this, "This line could not be parsed: " + value.toString());
                this.notifyParseErrorEvent(offendingLineEvent);
            }
            catch (IndexOutOfBoundsException ex) {
                this.mBadFeature = true;
                ParseErrorEvent offendingLineEvent = new ParseErrorEvent(this, "From must be less than To: " + value.toString());
                this.notifyParseErrorEvent(offendingLineEvent);
            }
        }
    }

    public synchronized void addParseErrorListener(ParseErrorListener theListener) {
        if (!this.mListeners.contains(theListener)) {
            this.mListeners.addElement(theListener);
        }
    }

    public synchronized void removeParseErrorListener(ParseErrorListener theListener) {
        if (this.mListeners.contains(theListener)) {
            this.mListeners.removeElement(theListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyParseErrorEvent(ParseErrorEvent theEvent) {
        Vector listeners;
        SwissprotProcessor swissprotProcessor = this;
        synchronized (swissprotProcessor) {
            listeners = (Vector)this.mListeners.clone();
        }
        int index = 0;
        while (index < listeners.size()) {
            ParseErrorListener client = (ParseErrorListener)listeners.elementAt(index);
            client.BadLineParsed(theEvent);
            ++index;
        }
    }

    public static class Factory
    implements SequenceBuilderFactory,
    Serializable {
        private SequenceBuilderFactory delegateFactory;

        public Factory(SequenceBuilderFactory delegateFactory) {
            this.delegateFactory = delegateFactory;
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new SwissprotProcessor(this.delegateFactory.makeSequenceBuilder());
        }

        public SequenceBuilder makeSequenceBuilder(String theSource) {
            return new SwissprotProcessor(this.delegateFactory.makeSequenceBuilder(), theSource);
        }
    }
}

