/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SymbolListCharSequence
implements CharSequence {
    private SymbolList syms;
    private Map alphaTokens;

    public SymbolListCharSequence(SymbolList syms) {
        SymbolTokenization sToke;
        FiniteAlphabet alphabet = (FiniteAlphabet)syms.getAlphabet();
        if (!(alphabet instanceof FiniteAlphabet)) {
            throw new IllegalArgumentException("Only SymbolLists using a FiniteAlphabet are supported by SymbolListCharSequence");
        }
        try {
            sToke = alphabet.getTokenization("token");
        }
        catch (BioException be) {
            throw new BioError(be, "Internal error: failed to get SymbolTokenization for SymbolList alphabet");
        }
        if (sToke.getTokenType() != SymbolTokenization.CHARACTER) {
            throw new IllegalArgumentException("Only FiniteAlphabets using a char token are supported by SymbolListCharSequence");
        }
        this.syms = syms;
        this.alphaTokens = new HashMap(Math.round((float)alphabet.size() / 0.75f) + 1);
        try {
            Iterator si = AlphabetManager.getAllSymbols(alphabet).iterator();
            while (si.hasNext()) {
                Symbol s = (Symbol)si.next();
                char symChar = sToke.tokenizeSymbol(s).charAt(0);
                this.alphaTokens.put(s, new Character(symChar));
            }
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Internal error: failed to tokenize a Symbol from an existing SymbolList");
        }
    }

    private SymbolListCharSequence(SymbolList syms, Map alphaTokens) {
        this.syms = syms;
        this.alphaTokens = alphaTokens;
    }

    public char charAt(int index) {
        return ((Character)this.alphaTokens.get(this.syms.symbolAt(index + 1))).charValue();
    }

    public int length() {
        return this.syms.length();
    }

    public CharSequence subSequence(int start, int end) {
        return new SymbolListCharSequence(this.syms.subList(start + 1, end + 1), this.alphaTokens);
    }

    public String toString() {
        return this.syms.seqString();
    }
}

