/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.directory;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.directory.ProviderNotFoundException;
import org.biojava.directory.RegistryConfiguration;
import org.biojava.directory.RegistryException;
import org.biojava.directory.SequenceDBProvider;
import org.biojava.utils.Services;

public class Registry {
    private RegistryConfiguration regConfig = null;
    static /* synthetic */ Class class$org$biojava$directory$SequenceDBProvider;

    public Registry(RegistryConfiguration regConfig) {
        this.regConfig = regConfig;
    }

    public SequenceDBLite getDatabase(String dbName) throws RegistryException, BioException {
        String providerName = "";
        List dbConfigs = (List)this.getRegistryConfiguration().getConfiguration().get(dbName);
        if (dbConfigs == null) {
            throw new RegistryException("Failed to find a configuration for database: " + dbName);
        }
        Iterator ci = dbConfigs.iterator();
        while (ci.hasNext()) {
            Map dbConfig = (Map)ci.next();
            providerName = (String)dbConfig.get("protocol");
            SequenceDBLite db = null;
            try {
                db = this.getProvider(providerName).getSequenceDB(dbConfig);
            }
            catch (RegistryException re) {
                continue;
            }
            catch (Exception e) {
                throw new RegistryException("Failed to configure database " + dbName);
            }
            if (db == null) continue;
            return db;
        }
        throw new RegistryException("Failed to find a configuration for database: " + dbName);
    }

    private SequenceDBProvider getProvider(String providerName) throws RegistryException {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Iterator implNames = Services.getImplementationNames(class$org$biojava$directory$SequenceDBProvider == null ? (class$org$biojava$directory$SequenceDBProvider = Registry.class$("org.biojava.directory.SequenceDBProvider")) : class$org$biojava$directory$SequenceDBProvider, loader).iterator();
            while (implNames.hasNext()) {
                String className = (String)implNames.next();
                try {
                    Class<?> clazz = loader.loadClass(className);
                    SequenceDBProvider seqDB = (SequenceDBProvider)clazz.newInstance();
                    if (!seqDB.getName().equals(providerName)) continue;
                    return seqDB;
                }
                catch (ClassNotFoundException ce) {
                    throw new RegistryException(ce, "Could not find class: " + className + " for service provider " + providerName);
                }
            }
            throw new ProviderNotFoundException("No such provider exists: " + providerName);
        }
        catch (Exception e) {
            throw new RegistryException(e, "Error accessing SequenceDBProvider services");
        }
    }

    public RegistryConfiguration getRegistryConfiguration() {
        return this.regConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

