/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JToggleButton;
import org.emboss.jemboss.editor.Sequence;

public class SequenceNameJButton
extends JToggleButton {
    private Sequence seq;
    private int boundWidth = 6;
    private int fontSize = 12;
    private String nameLabel;
    private int ypad = 0;
    private Font font = new Font("Monospaced", 0, this.fontSize);

    public SequenceNameJButton(Sequence sequence, int n) {
        this.seq = sequence;
        this.ypad = n;
        this.nameLabel = sequence.getID().equals("") ? new String("") : new String(sequence.getID() + "/" + Integer.toString(sequence.getLength()));
        this.setText(this.nameLabel);
        this.setBackground(Color.white);
        this.setHorizontalTextPosition(4);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setFont(this.font);
        this.setBorderPainted(false);
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.font = new Font("Monospaced", 0, this.fontSize);
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.setFont(this.font);
    }

    public Font getFont() {
        return this.font;
    }

    public int getPanelWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        return fontMetrics.stringWidth(this.nameLabel) + this.boundWidth;
    }

    public int getPanelHeight() {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boundWidth = fontMetrics.stringWidth("A");
        return fontMetrics.stringWidth("A") + this.boundWidth;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getPanelWidth(), this.getPanelHeight() + this.ypad);
    }
}

