/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.FeatureEdit;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.SelectionMenu;
import uk.ac.sanger.artemis.components.TextRequester;
import uk.ac.sanger.artemis.components.TextRequesterEvent;
import uk.ac.sanger.artemis.components.TextRequesterListener;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.plot.CodonUsageAlgorithm;
import uk.ac.sanger.artemis.sequence.BasePattern;
import uk.ac.sanger.artemis.sequence.BasePatternFormatException;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.MarkerRangeVector;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class AddMenu
extends SelectionMenu {
    static final KeyStroke CREATE_FROM_BASE_RANGE_KEY = KeyStroke.getKeyStroke(67, 2);
    public static final int CREATE_FROM_BASE_RANGE_KEY_CODE = 67;
    private GotoEventSource goto_event_source = null;
    private EntryGroup entry_group;
    private JMenuItem new_feature_item = null;
    private JMenuItem new_entry_item = null;
    private JMenuItem create_feature_from_range_item = null;
    private JMenuItem create_intron_features_item = null;
    private JMenuItem create_exon_features_item = null;
    private JMenuItem create_gene_features_item = null;
    private JMenuItem mark_orfs_with_size_item = null;
    private JMenuItem mark_empty_orfs_with_size_item = null;
    private JMenuItem mark_orfs_range_item = null;
    private JMenuItem mark_pattern_item = null;
    private JMenuItem mark_ambiguities_item = null;
    private BasePlotGroup base_plot_group;

    public AddMenu(JFrame frame, Selection selection, final EntryGroup entry_group, GotoEventSource goto_event_source, BasePlotGroup base_plot_group, String menu_name) {
        super(frame, menu_name, selection);
        this.entry_group = entry_group;
        this.base_plot_group = base_plot_group;
        this.new_feature_item = new JMenuItem("New Feature");
        this.new_feature_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.this.makeNewFeature();
            }
        });
        this.add(this.new_feature_item);
        this.create_feature_from_range_item = new JMenuItem("Create Feature From Base Range");
        this.create_feature_from_range_item.setAccelerator(CREATE_FROM_BASE_RANGE_KEY);
        this.create_feature_from_range_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.createFeatureFromBaseRange(AddMenu.this.getParentFrame(), AddMenu.this.getSelection(), entry_group, AddMenu.this.getGotoEventSource());
            }
        });
        this.add(this.create_feature_from_range_item);
        this.create_intron_features_item = new JMenuItem("Create Intron Features");
        this.create_intron_features_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.createIntronFeatures(AddMenu.this.getParentFrame(), AddMenu.this.getSelection(), entry_group);
            }
        });
        this.add(this.create_intron_features_item);
        this.create_exon_features_item = new JMenuItem("Create Exon Features");
        this.create_exon_features_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.createExonFeatures(AddMenu.this.getParentFrame(), AddMenu.this.getSelection(), entry_group);
            }
        });
        this.add(this.create_exon_features_item);
        this.create_gene_features_item = new JMenuItem("Create Gene Features");
        this.create_gene_features_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.createGeneFeatures(AddMenu.this.getParentFrame(), AddMenu.this.getSelection(), entry_group);
            }
        });
        this.add(this.create_gene_features_item);
        this.addSeparator();
        this.new_entry_item = new JMenuItem("New Entry");
        this.new_entry_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.this.makeNewEntry();
            }
        });
        this.add(this.new_entry_item);
        this.addSeparator();
        this.mark_orfs_with_size_item = new JMenuItem("Mark Open Reading Frames ...");
        this.mark_orfs_with_size_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.this.markORFSWithSize(false);
            }
        });
        this.add(this.mark_orfs_with_size_item);
        this.mark_empty_orfs_with_size_item = new JMenuItem("Mark Empty ORFs ...");
        this.mark_empty_orfs_with_size_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.this.markORFSWithSize(true);
            }
        });
        this.add(this.mark_empty_orfs_with_size_item);
        this.mark_orfs_range_item = new JMenuItem("Mark ORFs In Range ...");
        this.mark_orfs_range_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.this.markOpenReadingFramesInRange();
            }
        });
        this.add(this.mark_orfs_range_item);
        this.mark_pattern_item = new JMenuItem("Mark From Pattern ...");
        this.mark_pattern_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.this.makeFeaturesFromPattern();
            }
        });
        this.add(this.mark_pattern_item);
        this.mark_ambiguities_item = new JMenuItem("Mark Ambiguities");
        this.mark_ambiguities_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AddMenu.this.markAmbiguities();
            }
        });
        this.add(this.mark_ambiguities_item);
    }

    public AddMenu(JFrame frame, Selection selection, EntryGroup entry_group, GotoEventSource goto_event_source, BasePlotGroup base_plot_group) {
        this(frame, selection, entry_group, goto_event_source, base_plot_group, "Create");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeNewFeature() {
        if (this.entry_group.size() > 0) {
            if (this.entry_group.getDefaultEntry() == null) {
                new MessageDialog(this.getParentFrame(), "There is no default entry");
            } else {
                try {
                    this.entry_group.getActionController().startAction();
                    final Feature new_feature = this.entry_group.createFeature();
                    final FeatureEdit feature_edit = new FeatureEdit(new_feature, this.entry_group, this.getSelection(), this.getGotoEventSource());
                    final ActionListener cancel_listener = new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                new_feature.removeFromEntry();
                            }
                            catch (ReadOnlyException exception) {
                                throw new Error("internal error - unexpected exception: " + exception);
                            }
                        }
                    };
                    feature_edit.addCancelActionListener(cancel_listener);
                    feature_edit.addApplyActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            feature_edit.removeCancelActionListener(cancel_listener);
                        }
                    });
                    feature_edit.show();
                }
                catch (ReadOnlyException e) {
                    new MessageDialog(this.getParentFrame(), "feature not created: the default entry is read only");
                }
                finally {
                    this.entry_group.getActionController().endAction();
                }
            }
        } else {
            new MessageDialog(this.getParentFrame(), "Cannot make a feature without an existing entry");
        }
    }

    private void makeNewEntry() {
        this.entry_group.createEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createFeatureFromBaseRange(JFrame frame, final Selection selection, EntryGroup entry_group, GotoEventSource goto_event_source) {
        try {
            entry_group.getActionController().startAction();
            if (!SelectionMenu.checkForSelectionRange(frame, selection)) {
                return;
            }
            final MarkerRange range = selection.getMarkerRange();
            Entry default_entry = entry_group.getDefaultEntry();
            if (default_entry == null) {
                new MessageDialog(frame, "There is no default entry");
                return;
            }
            try {
                Feature temp_feature;
                Location new_location = range.createLocation();
                try {
                    temp_feature = default_entry.createFeature(Key.CDS, new_location);
                }
                catch (EntryInformationException e) {
                    Key default_key = default_entry.getEntryInformation().getDefaultKey();
                    try {
                        temp_feature = default_entry.createFeature(default_key, new_location);
                    }
                    catch (EntryInformationException ex) {
                        throw new Error("internal error - unexpected exception: " + ex);
                    }
                }
                final Feature new_feature = temp_feature;
                selection.setMarkerRange(null);
                selection.set(new_feature);
                final FeatureEdit feature_edit = new FeatureEdit(new_feature, entry_group, selection, goto_event_source);
                final ActionListener cancel_listener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            new_feature.removeFromEntry();
                            selection.setMarkerRange(range);
                        }
                        catch (ReadOnlyException exception) {
                            throw new Error("internal error - unexpected exception: " + exception);
                        }
                    }
                };
                feature_edit.addCancelActionListener(cancel_listener);
                feature_edit.addApplyActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        feature_edit.removeCancelActionListener(cancel_listener);
                    }
                });
                feature_edit.show();
            }
            catch (ReadOnlyException e) {
                new MessageDialog(frame, "feature not created: the default entry is read only");
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createIntronFeatures(JFrame frame, Selection selection, EntryGroup entry_group) {
        try {
            entry_group.getActionController().startAction();
            if (!SelectionMenu.checkForSelectionFeatures(frame, selection)) {
                return;
            }
            FeatureVector selected_features = selection.getAllFeatures();
            for (int feature_index = 0; feature_index < selected_features.size(); ++feature_index) {
                Location cds_location;
                RangeVector cds_ranges;
                Feature selection_feature = selected_features.elementAt(feature_index);
                if (!selection_feature.isProteinFeature() || (cds_ranges = (cds_location = selection_feature.getLocation()).getRanges()).size() < 2) continue;
                if (cds_location.isComplement()) {
                    cds_ranges.reverse();
                }
                for (int range_index = 0; range_index < cds_ranges.size() - 1; ++range_index) {
                    Range new_range;
                    int start_of_range_2;
                    int end_of_range_1 = cds_ranges.elementAt(range_index).getEnd();
                    if (end_of_range_1 > (start_of_range_2 = cds_ranges.elementAt(range_index + 1).getStart())) continue;
                    try {
                        new_range = new Range(end_of_range_1 + 1, start_of_range_2 - 1);
                    }
                    catch (OutOfRangeException e) {
                        throw new Error("internal error - unexpected exception: " + e);
                    }
                    RangeVector intron_ranges = new RangeVector();
                    intron_ranges.add(new_range);
                    Key intron_key = new Key("intron");
                    Location intron_location = new Location(intron_ranges, cds_location.isComplement());
                    QualifierVector qualifiers = new QualifierVector();
                    try {
                        selection_feature.getEntry().createFeature(intron_key, intron_location, qualifiers);
                        continue;
                    }
                    catch (ReadOnlyException e) {
                        throw new Error("internal error - unexpected exception: " + e);
                    }
                    catch (EntryInformationException e) {
                        throw new Error("internal error - unexpected exception: " + e);
                    }
                    catch (OutOfRangeException e) {
                        throw new Error("internal error - unexpected exception: " + e);
                    }
                }
            }
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createExonFeatures(JFrame frame, Selection selection, EntryGroup entry_group) {
        try {
            entry_group.getActionController().startAction();
            if (!SelectionMenu.checkForSelectionFeatures(frame, selection)) {
                return;
            }
            FeatureVector selected_features = selection.getAllFeatures();
            for (int feature_index = 0; feature_index < selected_features.size(); ++feature_index) {
                Feature selection_feature = selected_features.elementAt(feature_index);
                if (!selection_feature.isProteinFeature()) continue;
                Location cds_location = selection_feature.getLocation();
                RangeVector cds_ranges = cds_location.getRanges();
                for (int range_index = 0; range_index < cds_ranges.size(); ++range_index) {
                    Range this_range = cds_ranges.elementAt(range_index);
                    RangeVector exon_ranges = new RangeVector();
                    exon_ranges.add(this_range);
                    Key exon_key = new Key("exon");
                    Location exon_location = new Location(exon_ranges, cds_location.isComplement());
                    QualifierVector qualifiers = new QualifierVector();
                    try {
                        selection_feature.getEntry().createFeature(exon_key, exon_location, qualifiers);
                        continue;
                    }
                    catch (ReadOnlyException e) {
                        throw new Error("internal error - unexpected exception: " + e);
                    }
                    catch (EntryInformationException e) {
                        throw new Error("internal error - unexpected exception: " + e);
                    }
                    catch (OutOfRangeException e) {
                        throw new Error("internal error - unexpected exception: " + e);
                    }
                }
            }
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createGeneFeatures(JFrame frame, Selection selection, EntryGroup entry_group) {
        try {
            entry_group.getActionController().startAction();
            if (!SelectionMenu.checkForSelectionFeatures(frame, selection)) {
                return;
            }
            FeatureVector selected_features = selection.getAllFeatures();
            for (int feature_index = 0; feature_index < selected_features.size(); ++feature_index) {
                Feature selection_feature = selected_features.elementAt(feature_index);
                if (!selection_feature.isProteinFeature()) continue;
                Range max_range = selection_feature.getMaxRawRange();
                boolean complement_flag = selection_feature.getLocation().isComplement();
                RangeVector ranges = new RangeVector();
                ranges.add(max_range);
                Key gene_key = new Key("gene");
                Location gene_location = new Location(ranges, complement_flag);
                QualifierVector qualifiers = new QualifierVector();
                try {
                    selection_feature.getEntry().createFeature(gene_key, gene_location, qualifiers);
                    continue;
                }
                catch (ReadOnlyException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
                catch (EntryInformationException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
            }
        }
        finally {
            entry_group.getActionController().endAction();
        }
    }

    private void markORFSWithSize(final boolean empty_only) {
        int default_minimum_orf_size = Options.getOptions().getMinimumORFSize();
        TextRequester text_requester = new TextRequester("minimum open reading frame size?", 18, String.valueOf(default_minimum_orf_size));
        text_requester.addTextRequesterListener(new TextRequesterListener(){

            public void actionPerformed(TextRequesterEvent event) {
                if (event.getType() == 2) {
                    return;
                }
                String requester_text = event.getRequesterText().trim();
                if (requester_text.length() == 0) {
                    return;
                }
                try {
                    int minimum_orf_size = Integer.valueOf(requester_text);
                    AddMenu.this.markOpenReadingFrames(minimum_orf_size, empty_only);
                }
                catch (NumberFormatException e) {
                    new MessageDialog(AddMenu.this.getParentFrame(), "this is not a number: " + requester_text);
                }
            }
        });
        ((Component)text_requester).setVisible(true);
    }

    private void markOpenReadingFrames(int minimum_orf_size, boolean empty_only) {
        try {
            Entry new_entry = this.entry_group.createEntry("ORFS_" + minimum_orf_size + '+');
            int sequence_length = this.entry_group.getSequenceLength();
            Strand forward_strand = this.entry_group.getBases().getForwardStrand();
            MarkerRange forward_range = forward_strand.makeMarkerRangeFromPositions(1, sequence_length);
            this.markOpenReadingFrames(new_entry, forward_range, minimum_orf_size, empty_only);
            Strand backward_strand = this.entry_group.getBases().getReverseStrand();
            MarkerRange backward_range = backward_strand.makeMarkerRangeFromPositions(1, sequence_length);
            this.markOpenReadingFrames(new_entry, backward_range, minimum_orf_size, empty_only);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected OutOfRangeException");
        }
    }

    private void markOpenReadingFramesInRange() {
        if (!SelectionMenu.checkForSelectionRange(this.getParentFrame(), this.getSelection())) {
            return;
        }
        int default_minimum_orf_size = Options.getOptions().getMinimumORFSize();
        TextRequester text_requester = new TextRequester("minimum open reading frame size?", 18, String.valueOf(default_minimum_orf_size));
        text_requester.addTextRequesterListener(new TextRequesterListener(){

            public void actionPerformed(TextRequesterEvent event) {
                if (event.getType() == 2) {
                    return;
                }
                String requester_text = event.getRequesterText().trim();
                if (requester_text.length() == 0) {
                    return;
                }
                try {
                    int minimum_orf_size = Integer.valueOf(requester_text);
                    Entry new_entry = AddMenu.this.entry_group.createEntry("ORFS_" + minimum_orf_size + '+');
                    MarkerRange selection_range = AddMenu.this.getSelection().getMarkerRange();
                    AddMenu.this.markOpenReadingFrames(new_entry, selection_range, minimum_orf_size, false);
                }
                catch (NumberFormatException e) {
                    new MessageDialog(AddMenu.this.getParentFrame(), "this is not a number: " + requester_text);
                }
            }
        });
        ((Component)text_requester).setVisible(true);
    }

    private void markOpenReadingFrames(Entry entry, MarkerRange search_range, int minimum_orf_size, boolean empty_only) {
        MarkerRange[] forward_orf_ranges = Strand.getOpenReadingFrameRanges(search_range, minimum_orf_size);
        for (int i = 0; i < forward_orf_ranges.length; ++i) {
            Feature new_feature;
            MarkerRange this_range = forward_orf_ranges[i];
            try {
                new_feature = this.makeFeatureFromMarkerRange(entry, this_range, Key.CDS);
            }
            catch (EntryInformationException e) {
                new MessageDialog(this.getParentFrame(), "cannot continue: the default entry does not support CDS features");
                return;
            }
            catch (ReadOnlyException e) {
                new MessageDialog(this.getParentFrame(), "cannot continue: the default entry is read only");
                return;
            }
            if (!empty_only || !this.overlapsAnActiveSegment(new_feature)) continue;
            try {
                new_feature.removeFromEntry();
                continue;
            }
            catch (ReadOnlyException exception) {
                throw new Error("internal error - unexpected exception: " + exception);
            }
        }
    }

    private boolean overlapsAnActiveSegment(Feature test_feature) {
        FeatureVector overlapping_features;
        Range test_feature_range = test_feature.getMaxRawRange();
        try {
            overlapping_features = this.entry_group.getFeaturesInRange(test_feature_range);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        for (int feature_index = 0; feature_index < overlapping_features.size(); ++feature_index) {
            Feature current_feature = overlapping_features.elementAt(feature_index);
            if (current_feature == test_feature || !current_feature.isCDS()) continue;
            FeatureSegmentVector segments = current_feature.getSegments();
            for (int segment_index = 0; segment_index < segments.size(); ++segment_index) {
                int this_segment_frame;
                int test_feature_frame;
                FeatureSegment this_segment = segments.elementAt(segment_index);
                if (!test_feature_range.overlaps(this_segment.getRawRange()) || (test_feature_frame = test_feature.getSegments().elementAt(0).getFrameID()) != (this_segment_frame = this_segment.getFrameID())) continue;
                return true;
            }
        }
        return false;
    }

    private Feature makeFeatureFromMarkerRange(Entry entry, MarkerRange range, Key key) throws EntryInformationException, ReadOnlyException {
        try {
            Location new_location = range.createLocation();
            QualifierVector qualifiers = new QualifierVector();
            qualifiers.setQualifier(new Qualifier("note", "none"));
            Feature new_feature = entry.createFeature(key, new_location, qualifiers);
            CodonUsageAlgorithm codon_usage_algorithm = this.base_plot_group.getCodonUsageAlgorithm();
            if (codon_usage_algorithm != null) {
                int score = (int)(codon_usage_algorithm.getFeatureScore(new_feature) * 50.0f);
                if (score < 0) {
                    score = 0;
                }
                if (score > 100) {
                    score = 100;
                }
                String score_string = String.valueOf(score);
                new_feature.addQualifierValues(new Qualifier("score", score_string));
                int var_colour = 255 - score * 5 / 2;
                String colour_string = var_colour + " " + var_colour + " 255";
                new_feature.addQualifierValues(new Qualifier("colour", colour_string));
            }
            return new_feature;
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    private void makeFeaturesFromPattern() {
        TextRequester text_requester = new TextRequester("create features from this pattern:", 18, "");
        text_requester.addTextRequesterListener(new TextRequesterListener(){

            public void actionPerformed(TextRequesterEvent event) {
                String pattern_string = event.getRequesterText().trim();
                try {
                    if (pattern_string.length() == 0) {
                        new MessageDialog(AddMenu.this.getParentFrame(), "the pattern is too short");
                        return;
                    }
                    BasePattern pattern = new BasePattern(pattern_string);
                    AddMenu.this.makeFeaturesFromPattern(pattern);
                }
                catch (BasePatternFormatException e) {
                    new MessageDialog(AddMenu.this.getParentFrame(), "Illegal base pattern: " + pattern_string);
                }
            }
        });
        text_requester.show();
    }

    private void makeFeaturesFromPattern(BasePattern pattern) {
        YesNoDialog dialog;
        MarkerRangeVector matches = pattern.findMatches(this.entry_group.getBases(), null, this.entry_group.getSequenceLength());
        if (matches.size() == 0) {
            new MessageDialog(this.getParentFrame(), "no matches found for: " + pattern);
            return;
        }
        int TOO_MANY_MATCHES = 100;
        if (matches.size() > 100 && !(dialog = new YesNoDialog(this.getParentFrame(), matches.size() + " matches, continue?")).getResult()) {
            return;
        }
        Entry new_entry = this.entry_group.createEntry("matches: " + pattern);
        Key key = new_entry.getEntryInformation().getDefaultKey();
        for (int i = 0; i < matches.size(); ++i) {
            try {
                Feature new_feature = this.makeFeatureFromMarkerRange(new_entry, matches.elementAt(i), key);
                new_feature.setQualifier(new Qualifier("note", pattern.toString()));
                continue;
            }
            catch (EntryInformationException e) {
                new MessageDialog(this.getParentFrame(), "cannot continue: " + e.getMessage());
                return;
            }
            catch (ReadOnlyException e) {
                new MessageDialog(this.getParentFrame(), "cannot continue: the default entry is read only");
                return;
            }
        }
    }

    private void markAmbiguities() {
        Entry new_entry = null;
        Bases bases = this.entry_group.getBases();
        for (int i = 1; i <= bases.getLength(); ++i) {
            try {
                if (Bases.isLegalBase(bases.getBaseAt(i))) continue;
                int start_index = i;
                while (i < bases.getLength() && !Bases.isLegalBase(bases.getBaseAt(i + 1))) {
                    ++i;
                }
                int end_index = i;
                if (new_entry == null) {
                    new_entry = this.entry_group.createEntry("ambiguous bases");
                }
                Range range = new Range(start_index, end_index);
                String unsure_bases = bases.getSubSequence(range, 1);
                Location location = new Location(range);
                QualifierVector qualifiers = new QualifierVector();
                qualifiers.setQualifier(new Qualifier("note", unsure_bases));
                Feature feature = new_entry.createFeature(new Key("unsure"), location, qualifiers);
                continue;
            }
            catch (ReadOnlyException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            catch (EntryInformationException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        if (new_entry == null) {
            new MessageDialog(this.getParentFrame(), "No ambiguities found");
        } else if (new_entry.getFeatureCount() == 1) {
            new MessageDialog(this.getParentFrame(), "Created one feature");
        } else {
            new MessageDialog(this.getParentFrame(), "Created " + new_entry.getFeatureCount() + " features");
        }
    }

    private GotoEventSource getGotoEventSource() {
        return this.goto_event_source;
    }
}

