/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.GotoEvent;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.AddMenu;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.CanvasPanel;
import uk.ac.sanger.artemis.components.EditMenu;
import uk.ac.sanger.artemis.components.EntryGroupInfoDisplay;
import uk.ac.sanger.artemis.components.ViewMenu;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;

public abstract class EntryGroupPanel
extends CanvasPanel {
    final int fasta_in_browser_key = 70;
    final int view_fasta_key = 82;
    final int blastp_in_browser_key = 66;
    final int view_blastp_key = 9;
    private EntryGroup entry_group;
    private Selection selection;
    private GotoEventSource goto_event_source;
    private BasePlotGroup base_plot_group;

    public EntryGroupPanel(EntryGroup entry_group, Selection selection, GotoEventSource goto_event_source, BasePlotGroup base_plot_group) {
        this.entry_group = entry_group;
        this.selection = selection;
        this.goto_event_source = goto_event_source;
        this.base_plot_group = base_plot_group;
        this.getCanvas().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                EntryGroupPanel.this.handleKeyPress(event);
            }
        });
    }

    public GotoEventSource getGotoEventSource() {
        return this.goto_event_source;
    }

    public JFrame getParentFrame() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
        }
        return (JFrame)parent;
    }

    public EntryGroup getEntryGroup() {
        return this.entry_group;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public BasePlotGroup getBasePlotGroup() {
        return this.base_plot_group;
    }

    protected void makeSelectionVisible() {
        Marker first_base = this.getSelection().getStartBaseOfSelection();
        GotoEvent new_event = new GotoEvent(this, first_base);
        this.getGotoEventSource().sendGotoEvent(new_event);
    }

    protected boolean isMenuTrigger(MouseEvent event) {
        return event.isPopupTrigger() || (event.getModifiers() & 4) != 0;
    }

    private void handleKeyPress(KeyEvent event) {
        if (!event.isShiftDown() && event.getModifiers() != 0) {
            return;
        }
        FeatureVector selected_features = this.getSelection().getAllFeatures();
        if (selected_features.size() == 0) {
            MarkerRange marker_range = this.getSelection().getMarkerRange();
            if (marker_range != null) {
                switch (event.getKeyCode()) {
                    case 67: {
                        AddMenu.createFeatureFromBaseRange(this.getParentFrame(), this.getSelection(), this.entry_group, this.getGotoEventSource());
                    }
                }
            }
        } else {
            Feature first_selected_feature = selected_features.elementAt(0);
            int feature_index = this.getEntryGroup().indexOf(first_selected_feature);
            int event_key_code = event.getKeyCode();
            switch (event_key_code) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    if ((event_key_code == 37 || event_key_code == 39) && !event.isShiftDown()) break;
                    FeatureSegmentVector selected_segments = this.getSelection().getSelectedSegments();
                    if (event.isShiftDown()) {
                        if (selected_segments.size() <= 0) break;
                        FeatureSegment selected_segment = selected_segments.elementAt(0);
                        Feature selected_segment_feature = selected_segment.getFeature();
                        FeatureSegmentVector feature_segments = selected_segment_feature.getSegments();
                        int segment_index = feature_segments.indexOf(selected_segment);
                        if (event_key_code == 38 || event_key_code == 37 && !selected_segment_feature.isForwardFeature() || event_key_code == 39 && selected_segment_feature.isForwardFeature()) {
                            int segment_count = feature_segments.size();
                            int new_index = segment_index + 1;
                            if (segment_index >= segment_count - 1) break;
                            this.selection.set(feature_segments.elementAt(new_index));
                            break;
                        }
                        if (segment_index <= 0) break;
                        int new_index = segment_index - 1;
                        this.selection.set(feature_segments.elementAt(new_index));
                        break;
                    }
                    if (event_key_code == 40) {
                        if (feature_index >= this.getEntryGroup().getAllFeaturesCount() - 1) break;
                        this.selection.set(this.getEntryGroup().featureAt(feature_index + 1));
                        this.makeSelectionVisible();
                        break;
                    }
                    if (feature_index <= 0) break;
                    this.selection.set(this.getEntryGroup().featureAt(feature_index - 1));
                    this.makeSelectionVisible();
                    break;
                }
                case 69: {
                    EditMenu.editSelectedFeatures(this.getParentFrame(), this.getEntryGroup(), this.getSelection(), this.getGotoEventSource());
                    break;
                }
                case 85: {
                    EditMenu.undo(this.getParentFrame(), this.getSelection(), this.getEntryGroup());
                    break;
                }
                case 77: {
                    EditMenu.mergeFeatures(this.getParentFrame(), this.getSelection(), this.getEntryGroup());
                    break;
                }
                case 68: {
                    EditMenu.duplicateFeatures(this.getParentFrame(), this.getSelection(), this.getEntryGroup());
                    break;
                }
                case 127: {
                    EditMenu.deleteSelectedFeatures(this.getParentFrame(), this.getSelection(), this.getEntryGroup());
                    break;
                }
                case 84: {
                    EditMenu.trimSelected(this.getParentFrame(), this.getSelection(), this.getEntryGroup(), false, true);
                    break;
                }
                case 89: {
                    EditMenu.trimSelected(this.getParentFrame(), this.getSelection(), this.getEntryGroup(), true, true);
                    break;
                }
                case 81: {
                    EditMenu.extendToORF(this.getParentFrame(), this.getSelection(), this.getEntryGroup(), false);
                    break;
                }
                case 67: {
                    AddMenu.createFeatureFromBaseRange(this.getParentFrame(), this.getSelection(), this.entry_group, this.getGotoEventSource());
                    break;
                }
                case 86: {
                    ViewMenu.viewSelectedFeatures(this.getParentFrame(), this.getSelection());
                    break;
                }
                case 87: {
                    ViewMenu.plotSelectedFeatures(this.getParentFrame(), this.getSelection());
                    break;
                }
                case 79: {
                    new EntryGroupInfoDisplay(this.getParentFrame(), this.entry_group);
                    break;
                }
                case 70: {
                    this.viewResults("fasta", true);
                    break;
                }
                case 66: {
                    this.viewResults("blastp", true);
                    break;
                }
                case 82: {
                    this.viewResults("fasta", false);
                    break;
                }
                case 192: {
                    this.viewResults("blastp", false);
                    break;
                }
                case 72: {
                    this.viewResults("hth", false);
                }
            }
        }
    }

    private void viewResults(String program_name, boolean send_to_browser) {
        boolean sanger_options = Options.getOptions().getPropertyTruthValue("sanger_options");
        if (sanger_options && send_to_browser) {
            ViewMenu.viewExternalResults(this.getParentFrame(), this.getSelection(), program_name, true);
        } else {
            ViewMenu.viewExternalResults(this.getParentFrame(), this.getSelection(), program_name, false);
        }
    }
}

