/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.ExternalProgram;
import uk.ac.sanger.artemis.ExternalProgramException;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.FeatureViewer;
import uk.ac.sanger.artemis.components.KeyChoice;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.ProcessWatcher;
import uk.ac.sanger.artemis.components.ProcessWatcherEvent;
import uk.ac.sanger.artemis.components.ProcessWatcherListener;
import uk.ac.sanger.artemis.components.QualifierChoice;
import uk.ac.sanger.artemis.components.QualifierTextArea;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.OutOfDateException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierInfo;
import uk.ac.sanger.artemis.io.QualifierParseException;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.StreamQualifier;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class FeatureEdit
extends JFrame
implements EntryChangeListener,
FeatureChangeListener {
    private static Calendar calendar = Calendar.getInstance();
    private KeyChoice key_choice;
    private QualifierChoice qualifier_choice = null;
    private static final int LOCATION_TEXT_WIDTH = 80;
    private JTextField location_text = new JTextField(80);
    private JButton add_qualifier_button = new JButton("Add qualifier");
    private JButton ok_button = new JButton("OK");
    private JButton cancel_button = new JButton("Cancel");
    private JButton apply_button = new JButton("Apply");
    private QualifierTextArea qualifier_text_area;
    private Feature edit_feature;
    private GotoEventSource goto_event_source;
    private Entry edit_entry;
    private EntryGroup entry_group;
    private Date datestamp = null;
    private Selection selection;
    final String orig_qualifier_text;

    public FeatureEdit(Feature edit_feature, EntryGroup entry_group, Selection selection, GotoEventSource goto_event_source) {
        super("Artemis Feature Edit: " + edit_feature.getIDString() + (edit_feature.isReadOnly() ? "  -  (read only)" : ""));
        this.edit_feature = edit_feature;
        this.edit_entry = edit_feature.getEntry();
        this.entry_group = entry_group;
        this.selection = selection;
        this.goto_event_source = goto_event_source;
        this.createComponents();
        this.updateFromFeature();
        this.orig_qualifier_text = this.qualifier_text_area.getText();
        edit_feature.getEntry().addEntryChangeListener(this);
        edit_feature.addFeatureChangeListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                FeatureEdit.this.stopListening();
                FeatureEdit.this.dispose();
            }
        });
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
        this.qualifier_text_area.requestFocus();
    }

    public void stopListening() {
        this.getEntry().removeEntryChangeListener(this);
        this.getFeature().removeFeatureChangeListener(this);
    }

    public void entryChanged(EntryChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                if (event.getFeature() != this.edit_feature) break;
                this.stopListening();
                this.dispose();
                break;
            }
        }
    }

    public void addCancelActionListener(ActionListener l) {
        this.cancel_button.addActionListener(l);
    }

    public void removeCancelActionListener(ActionListener l) {
        this.cancel_button.removeActionListener(l);
    }

    public void addApplyActionListener(ActionListener l) {
        this.apply_button.addActionListener(l);
    }

    public void removeApplyActionListener(ActionListener l) {
        this.apply_button.removeActionListener(l);
    }

    public void featureChanged(FeatureChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.updateLocation();
                break;
            }
            case 3: {
                this.updateKey();
                break;
            }
            case 2: {
                if (this.qualifier_text_area.getText().equals(this.orig_qualifier_text)) {
                    this.updateFromFeature();
                    break;
                }
                String message = "warning: the qualifiers have changed outside the editor - view now?";
                YesNoDialog yes_no_dialog = new YesNoDialog(this, "warning: the qualifiers have changed outside the editor - view now?");
                if (!yes_no_dialog.getResult()) break;
                new FeatureViewer(this.getFeature());
                break;
            }
            default: {
                this.updateFromFeature();
            }
        }
    }

    private void createComponents() {
        this.qualifier_text_area = new QualifierTextArea();
        this.qualifier_text_area.setWrapStyleWord(true);
        this.key_choice = new KeyChoice(this.getEntryInformation(), this.getFeature().getKey());
        JPanel key_and_qualifier_panel = new JPanel();
        this.location_text.setBackground(Color.white);
        JPanel key_panel = new JPanel();
        key_panel.add(new JLabel("Key:"));
        key_panel.add(this.key_choice);
        key_and_qualifier_panel.setLayout(new BorderLayout());
        key_and_qualifier_panel.add((Component)key_panel, "West");
        this.qualifier_choice = new QualifierChoice(this.getEntryInformation(), this.key_choice.getSelectedItem(), null);
        JPanel qualifier_panel = new JPanel();
        JButton qualifier_add_button = new JButton("Add Qualifier:");
        qualifier_panel.add(qualifier_add_button);
        qualifier_panel.add(this.qualifier_choice);
        key_and_qualifier_panel.add((Component)qualifier_panel, "East");
        this.key_choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent _) {
                FeatureEdit.this.qualifier_choice.setKey(FeatureEdit.this.key_choice.getSelectedItem());
            }
        });
        qualifier_add_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String qualifier_name = (String)FeatureEdit.this.qualifier_choice.getSelectedItem();
                QualifierInfo qualifier_info = FeatureEdit.this.getEntryInformation().getQualifierInfo(qualifier_name);
                if (qualifier_info == null) {
                    qualifier_info = new QualifierInfo(qualifier_name, 4, null, null, false);
                }
                FeatureEdit.this.qualifier_text_area.append("/" + qualifier_name);
                switch (qualifier_info.getType()) {
                    case 1: {
                        if (qualifier_name.equals("GO")) {
                            Calendar calendar = Calendar.getInstance();
                            Date current_time = calendar.getTime();
                            SimpleDateFormat date_format = new SimpleDateFormat("yyyyMMdd");
                            StringBuffer result_buffer = new StringBuffer();
                            date_format.format(current_time, result_buffer, new FieldPosition(3));
                            String go_string = "aspect=; term=; GOid=GO:; evidence=ISS; db_xref=GOC:unpublished; with=UNIPROT:; date=" + result_buffer;
                            FeatureEdit.this.qualifier_text_area.append("=\"" + go_string + "\"");
                            break;
                        }
                        FeatureEdit.this.qualifier_text_area.append("=\"\"");
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                    default: {
                        FeatureEdit.this.qualifier_text_area.append("=");
                    }
                }
                FeatureEdit.this.qualifier_text_area.append("\n");
            }
        });
        JPanel middle_panel = new JPanel();
        middle_panel.setLayout(new BorderLayout());
        JPanel lower_panel = new JPanel();
        lower_panel.setLayout(new BorderLayout());
        JPanel outer_location_button_panel = new JPanel();
        lower_panel.add((Component)outer_location_button_panel, "North");
        outer_location_button_panel.setLayout(new BorderLayout());
        JPanel location_button_panel = new JPanel();
        outer_location_button_panel.add((Component)location_button_panel, "West");
        JPanel location_panel = new JPanel();
        location_panel.setLayout(new BorderLayout());
        location_panel.add((Component)new JLabel("location: "), "West");
        location_panel.add((Component)this.location_text, "Center");
        JButton complement_button = new JButton("Complement");
        location_button_panel.add(complement_button);
        complement_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureEdit.this.complementLocation();
            }
        });
        JButton grab_button = new JButton("Grab Range");
        location_button_panel.add(grab_button);
        grab_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureEdit.this.grabSelectedRange();
            }
        });
        JButton remove_button = new JButton("Remove Range");
        location_button_panel.add(remove_button);
        remove_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureEdit.this.removeSelectedRange();
            }
        });
        JButton goto_button = new JButton("Goto Feature");
        location_button_panel.add(goto_button);
        goto_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureEdit.this.goto_event_source.gotoBase(FeatureEdit.this.getFeature().getFirstBaseMarker());
            }
        });
        JButton select_button = new JButton("Select Feature");
        location_button_panel.add(select_button);
        select_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureEdit.this.getSelection().set(FeatureEdit.this.getFeature());
            }
        });
        boolean sanger_options = Options.getOptions().getPropertyTruthValue("sanger_options");
        if (sanger_options) {
            JButton tidy_button = new JButton("Tidy");
            location_button_panel.add(tidy_button);
            tidy_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        FeatureEdit.this.tidy();
                    }
                    catch (QualifierParseException exception) {
                        String error_string = exception.getMessage();
                        new MessageDialog(FeatureEdit.this, "Cannot tidy - qualifier error: " + error_string);
                    }
                }
            });
        }
        if (Options.getOptions().getProperty("external_editor") != null) {
            JButton external_fasta_edit_button = new JButton("MESS/FASTA");
            location_button_panel.add(external_fasta_edit_button);
            external_fasta_edit_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        if (FeatureEdit.this.getFeature().getQualifierByName("fasta_file") != null) {
                            String DEFAULT_MAX_EUK_FASTA_HITS = "10";
                            String max_fasta_hits_from_options = Options.getOptions().getProperty("mess_fasta_hits");
                            if (Options.getOptions().isEukaryoticMode()) {
                                String max_fasta_hits = max_fasta_hits_from_options == null ? "10" : max_fasta_hits_from_options;
                                FeatureEdit.this.externalEdit(new String[]{"-fasta", "-maxhits", max_fasta_hits, "-euk"});
                            } else if (max_fasta_hits_from_options == null) {
                                FeatureEdit.this.externalEdit(new String[]{"-fasta"});
                            } else {
                                FeatureEdit.this.externalEdit(new String[]{"-fasta", "-maxhits", max_fasta_hits_from_options});
                            }
                            return;
                        }
                    }
                    catch (InvalidRelationException invalidRelationException) {
                        // empty catch block
                    }
                    new MessageDialog(FeatureEdit.this, "nothing to edit - no /fasta_file qualifier");
                }
            });
            JButton external_blastp_edit_button = new JButton("MESS/BLASTP");
            location_button_panel.add(external_blastp_edit_button);
            external_blastp_edit_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        if (FeatureEdit.this.getFeature().getQualifierByName("blastp_file") != null) {
                            String DEFAULT_MAX_BLASTP_HITS = "10";
                            String max_blastp_hits_from_options = Options.getOptions().getProperty("mess_blastp_hits");
                            String max_blastp_hits = max_blastp_hits_from_options == null ? "10" : max_blastp_hits_from_options;
                            if (Options.getOptions().isEukaryoticMode()) {
                                FeatureEdit.this.externalEdit(new String[]{"-blastp", "-maxhits", max_blastp_hits, "-euk"});
                            } else {
                                FeatureEdit.this.externalEdit(new String[]{"-blastp", "-maxhits", max_blastp_hits});
                            }
                            return;
                        }
                    }
                    catch (InvalidRelationException invalidRelationException) {
                        // empty catch block
                    }
                    new MessageDialog(FeatureEdit.this, "nothing to edit - no /blastp_file qualifier");
                }
            });
            JButton external_go_edit_button = new JButton("MESS/GO");
            location_button_panel.add(external_go_edit_button);
            external_go_edit_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        if (FeatureEdit.this.getFeature().getQualifierByName("blastp+go_file") != null) {
                            String DEFAULT_MAX_GO_BLAST_HITS = "10";
                            String max_go_blast_hits_from_options = Options.getOptions().getProperty("mess_blast_go_hits");
                            String max_go_blast_hits = max_go_blast_hits_from_options == null ? "10" : max_go_blast_hits_from_options;
                            if (Options.getOptions().isEukaryoticMode()) {
                                FeatureEdit.this.externalEdit(new String[]{"-blastp+go", "-maxhits", max_go_blast_hits, "-euk"});
                            } else {
                                FeatureEdit.this.externalEdit(new String[]{"-blastp+go", "-maxhits", max_go_blast_hits});
                            }
                            return;
                        }
                    }
                    catch (InvalidRelationException invalidRelationException) {
                        // empty catch block
                    }
                    new MessageDialog(FeatureEdit.this, "nothing to edit - no /blastp+go_file qualifier");
                }
            });
        }
        middle_panel.add((Component)location_panel, "North");
        this.getContentPane().add((Component)key_and_qualifier_panel, "North");
        this.cancel_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureEdit.this.stopListening();
                FeatureEdit.this.dispose();
            }
        });
        if (!this.getFeature().isReadOnly()) {
            this.ok_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (FeatureEdit.this.setFeature()) {
                        FeatureEdit.this.stopListening();
                        FeatureEdit.this.dispose();
                    }
                }
            });
            this.apply_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FeatureEdit.this.setFeature();
                }
            });
        }
        FlowLayout flow_layout = new FlowLayout(1, 18, 5);
        JPanel ok_cancel_update_panel = new JPanel(flow_layout);
        if (!this.getFeature().isReadOnly()) {
            ok_cancel_update_panel.add(this.ok_button);
        }
        ok_cancel_update_panel.add(this.cancel_button);
        if (!this.getFeature().isReadOnly()) {
            ok_cancel_update_panel.add(this.apply_button);
        }
        this.getContentPane().add((Component)ok_cancel_update_panel, "South");
        middle_panel.add((Component)lower_panel, "Center");
        lower_panel.add((Component)new JScrollPane(this.qualifier_text_area), "Center");
        this.getContentPane().add((Component)middle_panel, "Center");
    }

    private void updateFromFeature() {
        this.datestamp = this.getFeature().getDatestamp();
        this.updateKey();
        this.updateLocation();
        this.updateQualifiers();
    }

    private void updateLocation() {
        this.location_text.setText(this.getFeature().getLocation().toStringShort());
    }

    private void complementLocation() {
        if (this.rationalizeLocation()) {
            if (this.location_text.getText().startsWith("complement(")) {
                String new_text = this.location_text.getText().substring(11);
                if (new_text.endsWith(")")) {
                    String new_text2 = new_text.substring(0, new_text.length() - 1);
                    this.location_text.setText(new_text2);
                } else {
                    this.location_text.setText(new_text);
                }
            } else {
                String new_text = this.location_text.getText();
                this.location_text.setText("complement(" + new_text + ")");
            }
        } else {
            new MessageDialog(this, "complement failed - current location cannot be parsed");
        }
    }

    private void tidy() throws QualifierParseException {
        StringBuffer buffer = new StringBuffer();
        QualifierVector qualifiers = this.qualifier_text_area.getParsedQualifiers(this.getEntryInformation());
        for (int qualifier_index = 0; qualifier_index < qualifiers.size(); ++qualifier_index) {
            Qualifier this_qualifier = qualifiers.elementAt(qualifier_index);
            QualifierInfo qualifier_info = this.getEntryInformation().getQualifierInfo(this_qualifier.getName());
            StringVector qualifier_strings = StreamQualifier.toStringVector(qualifier_info, this_qualifier);
            for (int value_index = 0; value_index < qualifier_strings.size(); ++value_index) {
                String qualifier_string = qualifier_strings.elementAt(value_index);
                buffer.append(this.tidyHelper(qualifier_string) + "\n");
            }
        }
        this.qualifier_text_area.setText(buffer.toString());
    }

    private String tidyHelper(String qualifier_string) {
        String temp_string = qualifier_string.startsWith("/transferred_") ? "/" + qualifier_string.substring(13) : qualifier_string;
        int start_index = temp_string.indexOf("<<FROM ");
        int end_index = temp_string.indexOf(">>");
        if (start_index != -1 && end_index != -1) {
            if (temp_string.length() > end_index + 2 && temp_string.charAt(end_index + 2) == ' ') {
                return temp_string.substring(0, start_index) + temp_string.substring(end_index + 3);
            }
            return temp_string.substring(0, start_index) + temp_string.substring(end_index + 2);
        }
        return temp_string;
    }

    private void grabSelectedRange() {
        if (!this.rationalizeLocation()) {
            new MessageDialog(this, "grab failed - current location cannot be parsed");
            return;
        }
        Range selected_range = this.getSelection().getSelectionRange();
        if (selected_range == null) {
            new MessageDialog(this, "grab failed - nothing is selected");
            return;
        }
        String old_location_text = this.location_text.getText();
        if (old_location_text.endsWith("))")) {
            String new_text = old_location_text.substring(0, old_location_text.length() - 2);
            this.location_text.setText(new_text + "," + selected_range.getStart() + ".." + selected_range.getEnd() + "))");
        } else if (old_location_text.endsWith(")")) {
            String new_text = old_location_text.substring(0, old_location_text.length() - 1);
            this.location_text.setText(new_text + "," + selected_range.getStart() + ".." + selected_range.getEnd() + ")");
        } else {
            this.location_text.setText(old_location_text + "," + selected_range.getStart() + ".." + selected_range.getEnd());
        }
        if (!this.rationalizeLocation()) {
            this.location_text.setText(old_location_text);
            new MessageDialog(this, "grab failed - location cannot be parsed after grabbing");
        }
    }

    private void removeSelectedRange() {
        Location location;
        if (!this.rationalizeLocation()) {
            new MessageDialog(this, "grab failed - current location cannot be parsed");
            return;
        }
        MarkerRange selected_marker_range = this.getSelection().getMarkerRange();
        if (selected_marker_range == null) {
            new MessageDialog(this, "remove range failed - no bases are selected");
            return;
        }
        Range selected_range = selected_marker_range.getRawRange();
        if (selected_marker_range.getStrand() != this.getFeature().getStrand()) {
            new MessageDialog(this, "remove range failed - you need to select some bases on the other strand");
            return;
        }
        try {
            location = new Location(this.location_text.getText());
        }
        catch (LocationParseException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        Range location_total_range = location.getTotalRange();
        if (!selected_range.overlaps(location_total_range)) {
            new MessageDialog(this, "remove range failed - the range you selected does not overlap the feature");
            return;
        }
        if (selected_range.contains(location_total_range)) {
            new MessageDialog(this, "remove range failed - the range you selected overlaps the whole feature");
            return;
        }
        RangeVector location_ranges = location.getRanges();
        boolean location_is_complemented = location.isComplement();
        RangeVector new_ranges = new RangeVector();
        for (int i = 0; i < location_ranges.size(); ++i) {
            Range this_range = location_ranges.elementAt(i);
            if (selected_range.overlaps(this_range)) {
                try {
                    Range new_start_range;
                    if (this_range.contains(selected_range) && this_range.getStart() != selected_range.getStart() && this_range.getEnd() != selected_range.getEnd()) {
                        new_start_range = this_range.change(selected_range.getEnd() + 1, this_range.getEnd());
                        new_ranges.add(new_start_range);
                        Range new_end_range = this_range.change(this_range.getStart(), selected_range.getStart() - 1);
                        new_ranges.add(new_end_range);
                        continue;
                    }
                    if (selected_range.contains(this_range)) continue;
                    if (this_range.getStart() < selected_range.getStart()) {
                        new_start_range = this_range.change(this_range.getStart(), selected_range.getStart() - 1);
                        new_ranges.add(new_start_range);
                        continue;
                    }
                    if (this_range.getEnd() > selected_range.getEnd()) {
                        Range new_end_range = this_range.change(selected_range.getEnd() + 1, this_range.getEnd());
                        new_ranges.add(new_end_range);
                        continue;
                    }
                    throw new Error("internal error - can't remove range");
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
            }
            new_ranges.add(this_range);
        }
        Location new_location = new Location(new_ranges, location_is_complemented);
        this.location_text.setText(new_location.toStringShort());
    }

    private boolean rationalizeLocation() {
        try {
            Location location = new Location(this.location_text.getText());
            this.location_text.setText(location.toStringShort());
            return true;
        }
        catch (LocationParseException e) {
            return false;
        }
    }

    private void externalEdit(String[] editor_extra_args) {
        try {
            String[] process_args;
            final String pre_edit_text = this.qualifier_text_area.getText();
            Date current_time = calendar.getTime();
            String temp_file_name = "/tmp/artemis_temp." + current_time.getTime();
            final File temp_file = new File(temp_file_name);
            FileWriter out_writer = new FileWriter(temp_file);
            PrintWriter print_writer = new PrintWriter(out_writer);
            print_writer.write(this.qualifier_text_area.getText());
            print_writer.close();
            out_writer.close();
            final File sequence_temp_file = new File(temp_file_name + ".seq");
            FileWriter sequence_out_writer = new FileWriter(sequence_temp_file);
            PrintWriter sequence_print_writer = new PrintWriter(sequence_out_writer);
            this.getFeature().writeBasesOfFeature(sequence_print_writer);
            sequence_print_writer.close();
            sequence_out_writer.close();
            String editor_path = Options.getOptions().getProperty("external_editor");
            if (editor_extra_args == null) {
                process_args = new String[]{temp_file.getCanonicalPath()};
            } else {
                process_args = new String[editor_extra_args.length + 1];
                System.arraycopy(editor_extra_args, 0, process_args, 0, editor_extra_args.length);
                process_args[process_args.length - 1] = temp_file.getCanonicalPath();
            }
            Process process = ExternalProgram.startProgram(editor_path, process_args);
            ProcessWatcher process_watcher = new ProcessWatcher(process, "editor", false);
            Thread watcher_thread = new Thread(process_watcher);
            watcher_thread.start();
            ProcessWatcherListener listener = new ProcessWatcherListener(){

                public void processFinished(ProcessWatcherEvent event) {
                    try {
                        String line;
                        FileReader file_reader = new FileReader(temp_file);
                        BufferedReader buffered_reader = new BufferedReader(file_reader);
                        StringBuffer buffer = new StringBuffer();
                        while ((line = buffered_reader.readLine()) != null) {
                            buffer.append(line + "\n");
                        }
                        String current_qualifier_text = FeatureEdit.this.qualifier_text_area.getText();
                        if (!current_qualifier_text.equals(pre_edit_text)) {
                            String message = "the qualifiers have changed - apply changes from the external editor?";
                            YesNoDialog yes_no_dialog = new YesNoDialog(FeatureEdit.this, "the qualifiers have changed - apply changes from the external editor?");
                            if (!yes_no_dialog.getResult()) {
                                return;
                            }
                        }
                        FeatureEdit.this.qualifier_text_area.setText(buffer.toString());
                        temp_file.delete();
                        sequence_temp_file.delete();
                        return;
                    }
                    catch (IOException e) {
                        new MessageDialog(FeatureEdit.this, "an error occured while reading from the editor: " + e);
                        return;
                    }
                }
            };
            process_watcher.addProcessWatcherListener(listener);
        }
        catch (IOException e) {
            new MessageDialog(this, "error while starting editor: " + e);
        }
        catch (ExternalProgramException e) {
            new MessageDialog(this, "error while starting editor: " + e);
        }
    }

    private void updateQualifiers() {
        this.qualifier_text_area.setText(this.getQualifierString());
    }

    private String getQualifierString() {
        StringBuffer buffer = new StringBuffer();
        QualifierVector qualifiers = this.getFeature().getQualifiers();
        for (int qualifier_index = 0; qualifier_index < qualifiers.size(); ++qualifier_index) {
            Qualifier this_qualifier = qualifiers.elementAt(qualifier_index);
            QualifierInfo qualifier_info = this.getEntryInformation().getQualifierInfo(this_qualifier.getName());
            StringVector qualifier_strings = StreamQualifier.toStringVector(qualifier_info, this_qualifier);
            for (int value_index = 0; value_index < qualifier_strings.size(); ++value_index) {
                String qualifier_string = qualifier_strings.elementAt(value_index);
                buffer.append(qualifier_string + "\n");
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFeature() {
        block19: {
            QualifierVector qualifiers;
            Location location;
            Key key = this.key_choice.getSelectedItem();
            KeyVector possible_keys = this.getEntryInformation().getValidKeys();
            if (possible_keys != null && !possible_keys.contains(key)) {
                YesNoDialog dialog = new YesNoDialog(this, "Add this new key: " + key + "?");
                if (dialog.getResult()) {
                    this.getEntryInformation().addKey(key);
                } else {
                    return false;
                }
            }
            try {
                location = new Location(this.location_text.getText());
            }
            catch (LocationParseException exception) {
                String error_string = exception.getMessage();
                System.out.println(error_string);
                new MessageDialog(this, "Cannot apply changes because of location error: " + error_string);
                return false;
            }
            try {
                qualifiers = this.qualifier_text_area.getParsedQualifiers(this.getEntryInformation());
            }
            catch (QualifierParseException exception) {
                String error_string = exception.getMessage();
                System.out.println(error_string);
                new MessageDialog(this, "Cannot apply changes because of a qualifier error: " + error_string);
                return false;
            }
            try {
                this.entry_group.getActionController().startAction();
                try {
                    this.getFeature().set(this.datestamp, key, location, qualifiers);
                }
                catch (OutOfDateException e) {
                    YesNoDialog dialog = new YesNoDialog(this, "the feature has changed since the edit window was opened, continue?");
                    if (dialog.getResult()) {
                        this.getFeature().set(key, location, qualifiers);
                        break block19;
                    }
                    boolean bl = false;
                    this.entry_group.getActionController().endAction();
                    return bl;
                }
            }
            catch (EntryInformationException e) {
                String error_string = e.getMessage();
                new MessageDialog(this, "Cannot apply changes: " + error_string);
                boolean bl = false;
                return bl;
            }
            catch (OutOfRangeException e) {
                new MessageDialog(this, "Cannot apply changes - the location is out of range for this sequence");
                boolean bl = false;
                return bl;
            }
            catch (ReadOnlyException e) {
                new MessageDialog(this, "Cannot apply changes - the feature is read only");
                boolean bl = false;
                return bl;
            }
            finally {
                this.entry_group.getActionController().endAction();
            }
        }
        this.dribble();
        return true;
    }

    public Feature getFeature() {
        return this.edit_feature;
    }

    private void dribble() {
        if (!Options.isUnixHost()) {
            return;
        }
        String dribble_file_name = this.getEntry().getName() != null ? ".dribble." + this.getEntry().getName() : ".dribble.no_name";
        try {
            FileWriter writer = new FileWriter(dribble_file_name, true);
            this.getFeature().writeNative(writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            System.err.println("IO exception while accessing " + dribble_file_name + ": " + e.getMessage());
        }
    }

    private Entry getEntry() {
        return this.edit_entry;
    }

    private void updateKey() {
        Key feature_key = this.getFeature().getKey();
        this.key_choice.setKey(feature_key);
    }

    public EntryInformation getEntryInformation() {
        return this.getEntry().getEntryInformation();
    }

    private Selection getSelection() {
        return this.selection;
    }
}

