/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.plot.CodonUsageAlgorithm;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;

public class FeatureInfo
extends JFrame
implements EntryChangeListener,
FeatureChangeListener {
    private Feature feature = null;
    private Entry entry;
    private JPanel aa_count_panel = null;
    private JLabel[] aa_count_list = null;
    private JPanel misc_info_panel = null;
    private JLabel molecular_weight_label = null;
    private JLabel correlation_scores_label = null;
    private JLabel usage_scores_label = null;
    private JPanel codon_info_panel = null;
    private JPanel button_panel = null;
    private JTextArea[][] codon_info_areas;
    private JTextArea[] base_count_info_areas;
    private final CodonUsageAlgorithm codon_usage_algorithm;

    public FeatureInfo(Feature feature, CodonUsageAlgorithm codon_usage_algorithm) {
        super("Feature infomation: " + feature.getIDString());
        this.feature = feature;
        this.entry = feature.getEntry();
        this.codon_usage_algorithm = codon_usage_algorithm;
        ((Component)this).setBackground(new Color(210, 210, 210));
        this.getContentPane().setBackground(new Color(210, 210, 210));
        this.codon_info_areas = new JTextArea[4][4];
        this.base_count_info_areas = new JTextArea[4];
        JPanel centre_panel = new JPanel();
        centre_panel.setLayout(new BorderLayout());
        this.makeCountList();
        this.getContentPane().add((Component)this.aa_count_panel, "West");
        this.makeMiscInfogrid();
        centre_panel.add((Component)this.misc_info_panel, "South");
        this.makeCodonInfogrid();
        centre_panel.add((Component)this.codon_info_panel, "Center");
        this.getContentPane().add((Component)centre_panel, "Center");
        this.button_panel = new JPanel();
        JButton close_button = new JButton("Close");
        close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureInfo.this.stopListening();
                FeatureInfo.this.dispose();
            }
        });
        this.button_panel.add(close_button);
        this.getContentPane().add((Component)this.button_panel, "South");
        this.updateComponents();
        this.getFeature().addFeatureChangeListener(this);
        this.getFeature().getEntry().addEntryChangeListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                FeatureInfo.this.stopListening();
                FeatureInfo.this.dispose();
            }
        });
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
        ((Component)this).setVisible(true);
    }

    private void stopListening() {
        this.getEntry().removeEntryChangeListener(this);
        this.getFeature().removeFeatureChangeListener(this);
    }

    public void entryChanged(EntryChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                if (event.getFeature() != this.getFeature()) break;
                this.stopListening();
                this.dispose();
                break;
            }
        }
    }

    public void featureChanged(FeatureChangeEvent event) {
        this.updateComponents();
    }

    private void makeMiscInfogrid() {
        this.misc_info_panel = new JPanel();
        GridLayout grid = new GridLayout(0, 1);
        this.misc_info_panel.setLayout(grid);
        this.molecular_weight_label = new JLabel();
        this.misc_info_panel.add(this.molecular_weight_label);
        this.correlation_scores_label = new JLabel();
        this.misc_info_panel.add(this.correlation_scores_label);
        if (this.codon_usage_algorithm != null) {
            this.usage_scores_label = new JLabel();
            this.misc_info_panel.add(this.usage_scores_label);
        }
    }

    private void makeCountList() {
        int i;
        this.aa_count_panel = new JPanel();
        JPanel aa_count_sub_panel1 = new JPanel();
        aa_count_sub_panel1.setLayout(new GridLayout(0, 1));
        this.aa_count_panel.add(aa_count_sub_panel1);
        JPanel aa_count_sub_panel2 = new JPanel();
        aa_count_sub_panel2.setLayout(new GridLayout(0, 1));
        this.aa_count_panel.add(aa_count_sub_panel2);
        this.aa_count_list = new JLabel[AminoAcidSequence.symbol_count];
        for (i = 0; i < AminoAcidSequence.symbol_count / 2; ++i) {
            this.aa_count_list[i] = new JLabel();
            aa_count_sub_panel1.add(this.aa_count_list[i]);
        }
        aa_count_sub_panel1.add(new JLabel(""));
        for (i = AminoAcidSequence.symbol_count / 2; i < AminoAcidSequence.symbol_count; ++i) {
            this.aa_count_list[i] = new JLabel();
            aa_count_sub_panel2.add(this.aa_count_list[i]);
        }
    }

    private void makeCodonInfogrid() {
        this.codon_info_panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        this.codon_info_panel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        int GRID_WIDTH = 7;
        c.gridwidth = 7;
        c.anchor = 11;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 0;
        JLabel dummy_label1 = new JLabel("");
        gridbag.setConstraints(dummy_label1, c);
        this.codon_info_panel.add(dummy_label1);
        JLabel dummy_label2 = new JLabel("");
        gridbag.setConstraints(dummy_label2, c);
        this.codon_info_panel.add(dummy_label2);
        for (int i = 0; i < Bases.letter_index.length; ++i) {
            JLabel new_label = new JLabel(String.valueOf(Bases.letter_index[i]).toUpperCase());
            gridbag.setConstraints(new_label, c);
            this.codon_info_panel.add(new_label);
        }
        JLabel dummy_label3 = new JLabel("");
        c.gridwidth = 0;
        gridbag.setConstraints(dummy_label3, c);
        this.codon_info_panel.add(dummy_label3);
        c.anchor = 17;
        c.gridwidth = 7;
        int ROWS = 4;
        for (int row = 0; row < 4; ++row) {
            JLabel new_label = new JLabel(String.valueOf(Bases.letter_index[row]).toUpperCase());
            new_label.setBorder(new EmptyBorder(1, 1, 1, 1));
            gridbag.setConstraints(new_label, c);
            this.codon_info_panel.add(new_label);
            this.base_count_info_areas[row] = new JTextArea(5, 15);
            this.base_count_info_areas[row].setEditable(false);
            JScrollPane scroll_pane = new JScrollPane(this.base_count_info_areas[row]);
            gridbag.setConstraints(scroll_pane, c);
            this.codon_info_panel.add(scroll_pane);
            Color parent_background = ((Component)this).getBackground();
            this.base_count_info_areas[row].setBackground(parent_background);
            for (int column = 2; column < 6; ++column) {
                JTextArea new_text = new JTextArea(5, 12);
                new_text.setText("r: " + row + " c: " + column);
                new_text.setEditable(false);
                new_text.setBackground(Color.white);
                JScrollPane scroll_pane2 = new JScrollPane(new_text);
                gridbag.setConstraints(scroll_pane2, c);
                this.codon_info_panel.add(scroll_pane2);
                this.codon_info_areas[row][column - 2] = new_text;
            }
            c.gridwidth = 0;
            JTextArea new_text = new JTextArea(5, 2);
            new_text.setText(Bases.letter_index[0] + "\n" + Bases.letter_index[1] + "\n" + Bases.letter_index[2] + "\n" + Bases.letter_index[3]);
            new_text.setEditable(false);
            JScrollPane scroll_pane3 = new JScrollPane(new_text);
            gridbag.setConstraints(scroll_pane3, c);
            this.codon_info_panel.add(scroll_pane3);
            c.gridwidth = 7;
        }
    }

    private void updateComponents() {
        this.updateAACountList();
        this.updateCodonInfoAreas();
        this.updateMolecularWeightLabel();
        this.updateCorrelationScoresLabel();
        this.updateUsageScoresLabel();
        this.updateBaseCounts();
        this.validate();
    }

    private void updateAACountList() {
        for (int i = 0; i < AminoAcidSequence.symbol_count; ++i) {
            if (i == AminoAcidSequence.symbol_count - 1 && this.getFeature().getResidueCount(i) == 0) {
                this.aa_count_list[i].setText("");
                continue;
            }
            String three_letter_abbreviation = AminoAcidSequence.getThreeLetterAbbreviation(i);
            char one_letter_abbreviation = Character.toUpperCase(AminoAcidSequence.getSymbolFromIndex(i));
            String label_string = three_letter_abbreviation + " (" + one_letter_abbreviation + "): " + this.getFeature().getResidueCount(i);
            this.aa_count_list[i].setText(label_string);
        }
    }

    private void updateCodonInfoAreas() {
        for (int first = 0; first < 4; ++first) {
            for (int second = 0; second < 4; ++second) {
                this.codon_info_areas[first][second].setText("");
                for (int third = 0; third < 4; ++third) {
                    String percent_string;
                    char this_codon_symbol = AminoAcidSequence.getCodonTranslation(Bases.letter_index[first], Bases.letter_index[second], Bases.letter_index[third]);
                    String this_codon_string = AminoAcidSequence.getThreeLetterAbbreviation(this_codon_symbol);
                    int this_codon_count = this.getFeature().getCodonCount(first, second, third);
                    int this_codon_index = AminoAcidSequence.getSymbolIndex(this_codon_symbol);
                    int this_amino_acid_count = this.getFeature().getResidueCount(this_codon_index);
                    if (this_amino_acid_count == this_codon_count) {
                        percent_string = "ALL";
                    } else if (this_amino_acid_count < this_codon_count) {
                        percent_string = "---";
                    } else {
                        int percentage = 100 * this_codon_count / this_amino_acid_count;
                        percent_string = String.valueOf(percentage) + "%";
                    }
                    String first_part_of_line = this_codon_string + " " + this_codon_count;
                    this.codon_info_areas[first][second].append(first_part_of_line);
                    int line_length_without_spaces = first_part_of_line.length() + percent_string.length();
                    for (int i = 0; i < 11 - line_length_without_spaces; ++i) {
                        this.codon_info_areas[first][second].append(" ");
                    }
                    this.codon_info_areas[first][second].append(percent_string);
                    if (third == 3) continue;
                    this.codon_info_areas[first][second].append("\n");
                }
            }
        }
    }

    private void updateMolecularWeightLabel() {
        String new_text = "Mol weight: " + this.getFeature().getTranslation().getMolecularWeight() + "  Start: " + this.getFeature().getFirstBase() + "  End: " + this.getFeature().getLastBase() + "  Bases: " + this.getFeature().getBaseCount() + "  AA length: " + this.getFeature().getTranslation().length();
        this.molecular_weight_label.setText(new_text);
    }

    private void updateBaseCounts() {
        int translation_base_count = this.getFeature().getTranslationBases().length();
        int amino_acid_count = this.getFeature().getTranslation().length();
        for (int i = 0; i < 4; ++i) {
            this.base_count_info_areas[i].setText("");
            String string = "ALL:" + this.updateBaseCountsFormatter(this.getFeature().getBaseCount(i), translation_base_count);
            this.base_count_info_areas[i].append(string);
            for (int codon_base_index = 0; codon_base_index < 3; ++codon_base_index) {
                String label = null;
                switch (codon_base_index) {
                    case 0: {
                        label = "\n1st:";
                        break;
                    }
                    case 1: {
                        label = "\n2nd:";
                        break;
                    }
                    case 2: {
                        label = "\n3rd:";
                    }
                }
                int base_count = this.getFeature().getPositionalBaseCount(codon_base_index, i);
                String string2 = label + this.updateBaseCountsFormatter(base_count, amino_acid_count);
                this.base_count_info_areas[i].append(string2);
            }
        }
    }

    private String updateBaseCountsFormatter(int base_count, int total) {
        String count_string = "     " + base_count;
        String percent_string = base_count < total ? " " + 100 * base_count / total + "%" : "ALL";
        int count_width = 5;
        int percent_width = 3;
        return count_string.substring(count_string.length() - 5) + " " + percent_string.substring(percent_string.length() - 3);
    }

    private void updateCorrelationScoresLabel() {
        int c_total = this.getFeature().getBaseCount(Bases.getIndexOfBase('c'));
        int g_total = this.getFeature().getBaseCount(Bases.getIndexOfBase('g'));
        int c3_count = this.getFeature().getPositionalBaseCount(2, Bases.getIndexOfBase('c'));
        int g1_count = this.getFeature().getPositionalBaseCount(0, Bases.getIndexOfBase('g'));
        int g3_count = this.getFeature().getPositionalBaseCount(2, Bases.getIndexOfBase('g'));
        String c3_score = c_total == 0 ? "ALL" : String.valueOf((double)(1000 * (3 * c3_count - c_total) / c_total) / 10.0);
        String g1_score = g_total == 0 ? "ALL" : String.valueOf((double)(1000 * (3 * g1_count - g_total) / g_total) / 10.0);
        String g3_score = g_total == 0 ? "ALL" : String.valueOf((double)(1000 * (3 * g3_count - g_total) / g_total) / 10.0);
        double cor1_2_score = (double)((int)this.getFeature().get12CorrelationScore() * 10) / 10.0;
        double gc_percent = (double)((int)(this.getFeature().getPercentGC() * 100.0)) / 100.0;
        String new_label = "position 1/2 score = " + cor1_2_score + "  " + "C3/G1/G3 (o-e)/e = " + c3_score + " " + g1_score + " " + g3_score + "  " + gc_percent + "% GC";
        this.correlation_scores_label.setText(new_label);
    }

    private void updateUsageScoresLabel() {
        if (this.codon_usage_algorithm != null) {
            String new_label = "usage score = " + this.codon_usage_algorithm.getFeatureScore(this.feature);
            this.usage_scores_label.setText(new_label);
        }
    }

    private Feature getFeature() {
        return this.feature;
    }

    private Entry getEntry() {
        return this.entry;
    }
}

