/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.BasePattern;
import uk.ac.sanger.artemis.sequence.BasePatternFormatException;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.util.StringVector;

public class Navigator
extends JFrame
implements EntryGroupChangeListener {
    final JRadioButton goto_base_button;
    final JRadioButton goto_base_pattern_button;
    final JRadioButton goto_aa_pattern_button;
    final JRadioButton goto_qualifier_button;
    final JRadioButton goto_gene_name_button;
    final JRadioButton goto_key_button;
    final JTextField goto_base_text;
    final JTextField goto_base_pattern_text;
    final JTextField goto_aa_pattern_text;
    final JTextField goto_qualifier_textfield;
    final JTextField goto_gene_name_textfield;
    final JTextField goto_feature_key_textfield;
    JRadioButton start_at_an_end_button;
    final JRadioButton start_at_selection_button;
    final JRadioButton search_backward_button;
    final JRadioButton ignore_case_button;
    final JRadioButton partial_match_button;
    final GotoEventSource goto_event_source;
    final EntryGroup entry_group;
    private final Selection selection;

    public Navigator(Selection selection, GotoEventSource goto_event_source, EntryGroup entry_group) {
        super("Artemis Navigator");
        this.selection = selection;
        this.entry_group = entry_group;
        this.goto_event_source = goto_event_source;
        Font default_font = Options.getOptions().getFont();
        GridBagLayout gridbag = new GridBagLayout();
        this.getContentPane().setLayout(gridbag);
        this.setFont(default_font);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 11;
        c.weighty = 0.0;
        int TEXT_FIELD_WIDTH = 25;
        ButtonGroup button_group = new ButtonGroup();
        this.goto_base_button = new JRadioButton("Goto Base:", true);
        button_group.add(this.goto_base_button);
        JPanel goto_base_panel = new JPanel();
        goto_base_panel.setLayout(new FlowLayout(0));
        goto_base_panel.add(this.goto_base_button);
        c.gridwidth = 2;
        gridbag.setConstraints(goto_base_panel, c);
        this.getContentPane().add(goto_base_panel);
        this.goto_base_text = new JTextField("", 25);
        c.gridwidth = 0;
        gridbag.setConstraints(this.goto_base_text, c);
        this.getContentPane().add(this.goto_base_text);
        this.goto_base_text.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Navigator.this.goto_base_button.setSelected(true);
                if (e.getKeyChar() == '\n') {
                    Navigator.this.doGoto();
                }
            }
        });
        this.goto_gene_name_button = new JRadioButton("Goto Feature With Gene Name:", true);
        button_group.add(this.goto_gene_name_button);
        JPanel goto_gene_name_panel = new JPanel();
        goto_gene_name_panel.setLayout(new FlowLayout(0));
        goto_gene_name_panel.add(this.goto_gene_name_button);
        c.gridwidth = 2;
        gridbag.setConstraints(goto_gene_name_panel, c);
        this.getContentPane().add(goto_gene_name_panel);
        this.goto_gene_name_textfield = new JTextField("", 25);
        c.gridwidth = 0;
        gridbag.setConstraints(this.goto_gene_name_textfield, c);
        this.getContentPane().add(this.goto_gene_name_textfield);
        this.goto_gene_name_textfield.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Navigator.this.goto_gene_name_button.setSelected(true);
                if (e.getKeyChar() == '\n') {
                    Navigator.this.doGoto();
                }
            }
        });
        this.goto_qualifier_button = new JRadioButton("Goto Feature With This Qualifier Value:", true);
        button_group.add(this.goto_qualifier_button);
        JPanel goto_qualifier_panel = new JPanel();
        goto_qualifier_panel.setLayout(new FlowLayout(0));
        goto_qualifier_panel.add(this.goto_qualifier_button);
        c.gridwidth = 2;
        gridbag.setConstraints(goto_qualifier_panel, c);
        this.getContentPane().add(goto_qualifier_panel);
        this.goto_qualifier_textfield = new JTextField("", 25);
        c.gridwidth = 0;
        gridbag.setConstraints(this.goto_qualifier_textfield, c);
        this.getContentPane().add(this.goto_qualifier_textfield);
        this.goto_qualifier_textfield.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Navigator.this.goto_qualifier_button.setSelected(true);
                if (e.getKeyChar() == '\n') {
                    Navigator.this.doGoto();
                }
            }
        });
        this.goto_key_button = new JRadioButton("Goto Feature With This Key:", true);
        button_group.add(this.goto_key_button);
        JPanel goto_key_panel = new JPanel();
        goto_key_panel.setLayout(new FlowLayout(0));
        goto_key_panel.add(this.goto_key_button);
        c.gridwidth = 2;
        gridbag.setConstraints(goto_key_panel, c);
        this.getContentPane().add(goto_key_panel);
        this.goto_feature_key_textfield = new JTextField("", 25);
        c.gridwidth = 0;
        gridbag.setConstraints(this.goto_feature_key_textfield, c);
        this.getContentPane().add(this.goto_feature_key_textfield);
        this.goto_feature_key_textfield.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Navigator.this.goto_key_button.setSelected(true);
                if (e.getKeyChar() == '\n') {
                    Navigator.this.doGoto();
                }
            }
        });
        this.goto_base_pattern_button = new JRadioButton("Find Base Pattern:", true);
        button_group.add(this.goto_base_pattern_button);
        JPanel goto_base_pattern_panel = new JPanel();
        goto_base_pattern_panel.setLayout(new FlowLayout(0));
        goto_base_pattern_panel.add(this.goto_base_pattern_button);
        c.gridwidth = 2;
        gridbag.setConstraints(goto_base_pattern_panel, c);
        this.getContentPane().add(goto_base_pattern_panel);
        this.goto_base_pattern_text = new JTextField("", 25);
        c.gridwidth = 0;
        gridbag.setConstraints(this.goto_base_pattern_text, c);
        this.getContentPane().add(this.goto_base_pattern_text);
        this.goto_base_pattern_text.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Navigator.this.goto_base_pattern_button.setSelected(true);
                if (e.getKeyChar() == '\n') {
                    Navigator.this.doGoto();
                }
            }
        });
        this.goto_aa_pattern_button = new JRadioButton("Find Amino Acid String:", true);
        button_group.add(this.goto_aa_pattern_button);
        JPanel goto_aa_pattern_panel = new JPanel();
        goto_aa_pattern_panel.setLayout(new FlowLayout(0));
        goto_aa_pattern_panel.add(this.goto_aa_pattern_button);
        c.gridwidth = 2;
        gridbag.setConstraints(goto_aa_pattern_panel, c);
        this.getContentPane().add(goto_aa_pattern_panel);
        this.goto_aa_pattern_text = new JTextField("", 25);
        c.gridwidth = 0;
        gridbag.setConstraints(this.goto_aa_pattern_text, c);
        this.getContentPane().add(this.goto_aa_pattern_text);
        this.goto_aa_pattern_text.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Navigator.this.goto_aa_pattern_button.setSelected(true);
                if (e.getKeyChar() == '\n') {
                    Navigator.this.doGoto();
                }
            }
        });
        this.goto_base_button.setSelected(true);
        ButtonGroup start_position_button_group = new ButtonGroup();
        JPanel start_at_an_end_panel = new JPanel();
        this.start_at_an_end_button = new JRadioButton("Start search at beginning (or end)", true);
        start_position_button_group.add(this.start_at_an_end_button);
        c.gridwidth = 0;
        start_at_an_end_panel.setLayout(new FlowLayout(0));
        start_at_an_end_panel.add(this.start_at_an_end_button);
        gridbag.setConstraints(start_at_an_end_panel, c);
        this.getContentPane().add(start_at_an_end_panel);
        JPanel start_at_selection_panel = new JPanel();
        this.start_at_selection_button = new JRadioButton("Start search at selection", false);
        start_position_button_group.add(this.start_at_selection_button);
        start_at_selection_panel.setLayout(new FlowLayout(0));
        start_at_selection_panel.add(this.start_at_selection_button);
        c.gridwidth = 0;
        gridbag.setConstraints(start_at_selection_panel, c);
        this.getContentPane().add(start_at_selection_panel);
        JPanel option_button_panel = new JPanel();
        option_button_panel.setLayout(new FlowLayout(0));
        this.search_backward_button = new JRadioButton("Search Backward", false);
        this.ignore_case_button = new JRadioButton("Ignore Case", true);
        this.partial_match_button = new JRadioButton("Allow Substring Matches", true);
        option_button_panel.add(this.search_backward_button);
        option_button_panel.add(this.ignore_case_button);
        option_button_panel.add(this.partial_match_button);
        c.gridwidth = 0;
        gridbag.setConstraints(option_button_panel, c);
        this.getContentPane().add(option_button_panel);
        JButton goto_button = new JButton("Goto");
        goto_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Navigator.this.doGoto();
            }
        });
        JButton clear_button = new JButton("Clear");
        clear_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Navigator.this.clear();
            }
        });
        JButton close_button = new JButton("Close");
        close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Navigator.this.dispose();
            }
        });
        FlowLayout flow_layout = new FlowLayout(1, 15, 5);
        JPanel close_and_goto_panel = new JPanel(flow_layout);
        close_and_goto_panel.add(goto_button);
        close_and_goto_panel.add(clear_button);
        close_and_goto_panel.add(close_button);
        gridbag.setConstraints(close_and_goto_panel, c);
        this.getContentPane().add(close_and_goto_panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Navigator.this.getEntryGroup().removeEntryGroupChangeListener(Navigator.this);
                Navigator.this.dispose();
            }
        });
        this.getEntryGroup().addEntryGroupChangeListener(this);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
        ((Component)this).setVisible(true);
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 6: {
                this.getEntryGroup().removeEntryGroupChangeListener(this);
                this.dispose();
            }
        }
    }

    public static MarkerRange findBasePattern(BasePattern pattern, EntryGroup entry_group, Selection selection, boolean start_at_end, boolean search_backwards) {
        Marker selection_base = selection.getLowestBaseOfSelection();
        Marker start_position = start_at_end || selection_base == null ? null : selection_base;
        MarkerRange match_range = pattern.findMatch(entry_group.getBases(), start_position, entry_group.getSequenceLength(), search_backwards);
        if (match_range == null) {
            return null;
        }
        return match_range;
    }

    public static MarkerRange findAminoAcidSequence(AminoAcidSequence sequence, EntryGroup entry_group, Selection selection, boolean start_at_end, boolean search_backwards) {
        Marker selection_base = selection.getLowestBaseOfSelection();
        Marker start_position = start_at_end || selection_base == null ? null : selection_base;
        MarkerRange match_range = search_backwards ? sequence.findMatch(entry_group.getBases(), start_position, true) : sequence.findMatch(entry_group.getBases(), start_position, false);
        if (match_range == null) {
            return null;
        }
        return match_range;
    }

    private void doGoto() {
        if (this.goto_base_button.isSelected()) {
            this.doGotoBase();
            return;
        }
        if (this.goto_base_pattern_button.isSelected()) {
            this.doGotoBasePattern();
            return;
        }
        if (this.goto_aa_pattern_button.isSelected()) {
            this.doGotoAAPattern();
            return;
        }
        if (this.goto_gene_name_button.isSelected()) {
            StringVector qualifiers_to_search = new StringVector();
            qualifiers_to_search.add(Options.getOptions().getAllGeneNames());
            this.doGotoQualifierValue(qualifiers_to_search, this.goto_gene_name_textfield.getText().trim());
            return;
        }
        if (this.goto_qualifier_button.isSelected()) {
            this.doGotoQualifierValue(null, this.goto_qualifier_textfield.getText().trim());
            return;
        }
        if (this.goto_key_button.isSelected()) {
            this.doGotoKey();
            return;
        }
    }

    private void clear() {
        this.goto_base_text.setText("");
        this.goto_base_pattern_text.setText("");
        this.goto_aa_pattern_text.setText("");
        this.goto_qualifier_textfield.setText("");
        this.goto_gene_name_textfield.setText("");
        this.goto_feature_key_textfield.setText("");
    }

    private void searchTextEmptyError() {
        new MessageDialog(this, "You have not entered a value to search for");
    }

    private void doGotoBase() {
        String number_string = this.goto_base_text.getText().trim();
        if (number_string.length() == 0) {
            new MessageDialog(this, "you have not entered a number to go to");
            return;
        }
        try {
            int destination_base = Integer.valueOf(number_string);
            MarkerRange destination_range = this.goto_event_source.gotoBase(destination_base);
            if (destination_range == null) {
                new MessageDialog(this, "the base is out of range for this sequence");
            } else {
                this.getSelection().setMarkerRange(destination_range);
            }
        }
        catch (NumberFormatException e) {
            new MessageDialog(this, "Cannot understand this number: " + this.goto_base_text.getText());
        }
    }

    private void doGotoBasePattern() {
        try {
            String pattern_string = this.goto_base_pattern_text.getText().trim();
            if (pattern_string.length() == 0) {
                new MessageDialog(this, "you have not entered a pattern to go to");
                return;
            }
            BasePattern pattern = new BasePattern(pattern_string);
            boolean start_at_an_end = this.start_at_an_end_button.isSelected();
            this.start_at_selection_button.setSelected(true);
            MarkerRange match_range = Navigator.findBasePattern(pattern, this.getEntryGroup(), this.getSelection(), start_at_an_end, this.search_backward_button.isSelected());
            if (match_range == null) {
                new MessageDialog(this, "reached the end of sequence");
            } else {
                this.getSelection().setMarkerRange(match_range);
                Marker first_selected_base = this.getSelection().getLowestBaseOfSelection();
                this.goto_event_source.gotoBase(first_selected_base);
            }
        }
        catch (BasePatternFormatException e) {
            new MessageDialog(this, "Illegal base pattern: " + this.goto_base_pattern_text.getText());
        }
    }

    private void doGotoAAPattern() {
        String pattern_string = this.goto_aa_pattern_text.getText().trim();
        if (pattern_string.length() == 0) {
            new MessageDialog(this, "you have not entered a pattern to go to");
            return;
        }
        AminoAcidSequence pattern = new AminoAcidSequence(pattern_string);
        boolean start_at_an_end = this.start_at_an_end_button.isSelected();
        this.start_at_selection_button.setSelected(true);
        boolean search_backwards = this.search_backward_button.isSelected();
        MarkerRange match_range = Navigator.findAminoAcidSequence(pattern, this.getEntryGroup(), this.getSelection(), start_at_an_end, search_backwards);
        if (match_range == null) {
            new MessageDialog(this, "reached the end of sequence");
        } else {
            this.getSelection().setMarkerRange(match_range);
            this.goto_event_source.gotoBase(this.getSelection().getLowestBaseOfSelection());
        }
    }

    private void doGotoQualifierValue(StringVector qualifiers_to_search, String search_text) {
        if (search_text.equals("")) {
            this.searchTextEmptyError();
            return;
        }
        FeatureVector selected_features = this.getSelection().getAllFeatures();
        int index = selected_features.size() == 0 || this.start_at_an_end_button.isSelected() ? -1 : this.getEntryGroup().indexOf(selected_features.elementAt(0));
        Feature found_feature = null;
        if (this.search_backward_button.isSelected()) {
            int first_search_feature_index = index == -1 ? this.getEntryGroup().getAllFeaturesCount() - 1 : index - 1;
            for (int i = first_search_feature_index; i >= 0; --i) {
                Feature this_feature = this.getEntryGroup().featureAt(i);
                if (!this_feature.containsText(search_text, this.ignore_case_button.isSelected(), this.partial_match_button.isSelected(), qualifiers_to_search)) continue;
                found_feature = this_feature;
                break;
            }
        } else {
            int first_search_feature_index = index == -1 ? 0 : index + 1;
            for (int i = first_search_feature_index; i < this.getEntryGroup().getAllFeaturesCount(); ++i) {
                Feature this_feature = this.getEntryGroup().featureAt(i);
                if (!this_feature.containsText(search_text, this.ignore_case_button.isSelected(), this.partial_match_button.isSelected(), qualifiers_to_search)) continue;
                found_feature = this_feature;
                break;
            }
        }
        if (found_feature == null) {
            this.getSelection().clear();
            this.start_at_an_end_button.setSelected(true);
            new MessageDialog(this, "text not found");
        } else {
            this.getSelection().set(found_feature);
            this.goto_event_source.gotoBase(this.getSelection().getLowestBaseOfSelection());
            this.start_at_selection_button.setSelected(true);
        }
    }

    private void doGotoKey() {
        FeatureVector selected_features = this.getSelection().getAllFeatures();
        int index = selected_features.size() == 0 || this.start_at_an_end_button.isSelected() ? -1 : this.getEntryGroup().indexOf(selected_features.elementAt(0));
        String search_key_string = this.goto_feature_key_textfield.getText().trim();
        if (search_key_string.equals("")) {
            this.searchTextEmptyError();
            return;
        }
        Feature found_feature = null;
        if (this.search_backward_button.isSelected()) {
            int first_search_feature_index = index == -1 ? this.getEntryGroup().getAllFeaturesCount() - 1 : index - 1;
            for (int i = first_search_feature_index; i >= 0; --i) {
                Feature this_feature = this.getEntryGroup().featureAt(i);
                if (!this.keyMatches(this_feature, search_key_string)) continue;
                found_feature = this_feature;
                break;
            }
        } else {
            int first_search_feature_index = index == -1 ? 0 : index + 1;
            for (int i = first_search_feature_index; i < this.getEntryGroup().getAllFeaturesCount(); ++i) {
                Feature this_feature = this.getEntryGroup().featureAt(i);
                if (!this.keyMatches(this_feature, search_key_string)) continue;
                found_feature = this_feature;
                break;
            }
        }
        if (found_feature == null) {
            this.getSelection().clear();
            this.start_at_an_end_button.setSelected(true);
            new MessageDialog(this, "key not found");
        } else {
            this.getSelection().set(found_feature);
            this.goto_event_source.gotoBase(this.getSelection().getLowestBaseOfSelection());
            this.start_at_selection_button.setSelected(true);
        }
    }

    public boolean keyMatches(Feature test_feature, String search_key_string) {
        String feature_key_string = this.ignore_case_button.isSelected() ? test_feature.getKey().toString().toLowerCase() : test_feature.getKey().toString();
        return feature_key_string.equals(search_key_string.toLowerCase());
    }

    private Selection getSelection() {
        return this.selection;
    }

    private EntryGroup getEntryGroup() {
        return this.entry_group;
    }
}

