/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import nsdb.NucFeature;
import nsdb.NucFeaturePackage.QualifierValue_u;
import type.NoResult;
import uk.ac.sanger.artemis.io.ComparableFeature;
import uk.ac.sanger.artemis.io.CorbaEntry;
import uk.ac.sanger.artemis.io.EMBLObject;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.InvalidKeyException;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class CorbaFeature
extends EMBLObject
implements ComparableFeature {
    private NucFeature feature_handle;
    private Location location;
    private Key key;
    private QualifierVector qualifiers = null;
    private CorbaEntry entry;
    private final long id = id_counter++;
    private static long id_counter = 0L;

    public CorbaFeature(NucFeature feature_handle) throws LocationParseException, InvalidKeyException, NoResult, InvalidRelationException {
        this.feature_handle = feature_handle;
        String location_string = feature_handle.getLocation().getLocationString();
        this.location = new Location(location_string);
        this.key = new Key(feature_handle.getKey());
        this.grabQualifiers();
    }

    public void set(Key key, Location location, QualifierVector qualifiers) throws InvalidRelationException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    private void setEntry(CorbaEntry entry) {
        this.entry = entry;
    }

    void setCorbaEntry(CorbaEntry entry) {
        this.setEntry(entry);
    }

    public void setKey(Key key) throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void setLocation(Location location) throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void setQualifiers(QualifierVector qualifiers) throws InvalidRelationException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void setQualifier(Qualifier qualifier) throws InvalidRelationException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void removeQualifierByName(String name) throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public Qualifier addQualifierValues(Qualifier qualifier) throws InvalidRelationException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public long getNumericID() {
        return this.id;
    }

    public Key getKey() {
        return this.key;
    }

    public Location getLocation() {
        return this.location;
    }

    public QualifierVector getQualifiers() {
        return this.qualifiers;
    }

    public Qualifier getQualifierByName(String name) {
        return this.getQualifiers().getQualifierByName(name);
    }

    public int getFirstBase() {
        return this.getLocation().getFirstBase();
    }

    public int getLastBase() {
        return this.getLocation().getLastBase();
    }

    public Entry getEntry() {
        return this.entry;
    }

    public Feature copy() {
        return new EmblStreamFeature(this);
    }

    public boolean isReadOnly() {
        return true;
    }

    private void grabQualifiers() throws InvalidRelationException {
        this.qualifiers = new QualifierVector();
        try {
            nsdb.NucFeaturePackage.Qualifier[] corba_qualifier_handles = this.feature_handle.getQualifiers();
            for (int i = 0; i < corba_qualifier_handles.length; ++i) {
                nsdb.NucFeaturePackage.Qualifier this_corba_qualifier = corba_qualifier_handles[i];
                StringVector values = this.getQualifierStringValues(this_corba_qualifier);
                EntryInformation entry_info = this.getEntryInformation();
                String qualifier_name = this_corba_qualifier.name;
                if (!entry_info.isValidQualifier(this.getKey(), qualifier_name)) {
                    String message = this.getKey() + " cannot have " + qualifier_name + " as a qualifier";
                    throw new InvalidRelationException(message, this.getKey(), new Qualifier(qualifier_name, values));
                }
                if (values.size() == 0) {
                    this.qualifiers.setQualifier(new Qualifier(this_corba_qualifier.name));
                    continue;
                }
                this.qualifiers.setQualifier(new Qualifier(this_corba_qualifier.name, values));
            }
        }
        catch (NoResult e) {
            System.out.println("unexpected NoResult exception while reading from corba " + (Object)((Object)e));
        }
    }

    private StringVector getQualifierStringValues(nsdb.NucFeaturePackage.Qualifier qualifier) {
        QualifierValue_u[] corba_values = qualifier.values;
        StringVector return_array = new StringVector();
        block11: for (int value_index = 0; value_index < corba_values.length; ++value_index) {
            QualifierValue_u corba_value = corba_values[value_index];
            switch (corba_value.discriminator()) {
                case 1: {
                    return_array.add(corba_value.text());
                    continue block11;
                }
                case 3: {
                    return_array.add(String.valueOf(corba_value.integer()));
                    continue block11;
                }
                case 4: {
                    return_array.add(String.valueOf(corba_value.real()));
                    continue block11;
                }
                case 17: {
                    return_array.add(String.valueOf(corba_value.translation_exception()));
                    continue block11;
                }
                case 18: {
                    return_array.add(String.valueOf(corba_value.codon_translation()));
                    continue block11;
                }
                case 19: {
                    return_array.add(String.valueOf(corba_value.anti_codon()));
                    continue block11;
                }
                case 20: {
                    return_array.add(String.valueOf(corba_value.splice_consensus()));
                    continue block11;
                }
                case 21: {
                    return_array.add(String.valueOf(corba_value.repeat_unit()));
                    continue block11;
                }
                case 22: {
                    return_array.add(String.valueOf(corba_value.db_xref()));
                }
            }
        }
        return return_array;
    }

    private EntryInformation getEntryInformation() {
        if (this.getEntry() == null) {
            return SimpleEntryInformation.getDefaultEntryInformation();
        }
        return this.getEntry().getEntryInformation();
    }
}

