/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import uk.ac.sanger.artemis.io.LowerInteger;
import uk.ac.sanger.artemis.io.UpperInteger;

public class LocationLexer {
    private String location_string;

    public LocationLexer(String location_string) {
        this.location_string = location_string;
    }

    public TokenEnumeration getTokens() {
        return new TokenEnumeration(this.location_string);
    }

    public class TokenEnumeration {
        private String location_string;
        private int next_char_index = 0;
        private Object peeked_object = null;

        public TokenEnumeration(String location_string) {
            this.location_string = location_string;
        }

        public Object peekElement() {
            if (this.peeked_object == null) {
                this.peeked_object = this.removeNextToken();
            }
            return this.peeked_object;
        }

        public Object nextElement() {
            Object o = this.removeNextToken();
            return o;
        }

        public boolean eatToken(String token) {
            if (this.peekElement() instanceof String && ((String)this.peekElement()).equals(token)) {
                this.nextElement();
                return true;
            }
            return false;
        }

        public boolean eatToken(char token) {
            if (this.peekElement() instanceof Character && ((Character)this.peekElement()).charValue() == token) {
                this.nextElement();
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer spare_tokens_string = new StringBuffer(100);
            Object next_token = this.nextElement();
            while (next_token != null) {
                spare_tokens_string.append(next_token.toString());
                next_token = this.nextElement();
            }
            return spare_tokens_string.toString();
        }

        private Object removeNextToken() {
            if (this.peeked_object == null) {
                char current_char;
                block8: while (true) {
                    if (this.next_char_index == this.location_string.length()) {
                        return null;
                    }
                    current_char = this.location_string.charAt(this.next_char_index);
                    switch (current_char) {
                        case '\t': 
                        case ' ': {
                            ++this.next_char_index;
                            continue block8;
                        }
                        case '(': 
                        case ')': 
                        case ',': 
                        case ':': 
                        case '^': {
                            ++this.next_char_index;
                            return new Character(current_char);
                        }
                        case '>': {
                            ++this.next_char_index;
                            if (this.next_char_index < this.location_string.length() && Character.isDigit(this.location_string.charAt(this.next_char_index))) {
                                return new UpperInteger(this.removeInteger());
                            }
                            return new Character('>');
                        }
                        case '<': {
                            ++this.next_char_index;
                            if (this.next_char_index < this.location_string.length() && Character.isDigit(this.location_string.charAt(this.next_char_index))) {
                                return new LowerInteger(this.removeInteger());
                            }
                            return new Character('<');
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            return this.removeInteger();
                        }
                        case '.': {
                            if (this.next_char_index + 1 == this.location_string.length()) {
                                ++this.next_char_index;
                                return new Character('.');
                            }
                            if (this.location_string.charAt(this.next_char_index + 1) == '.') {
                                this.next_char_index += 2;
                                return "..";
                            }
                            ++this.next_char_index;
                            return new Character('.');
                        }
                    }
                    break;
                }
                String label = this.removeLabel();
                if (label.equals("")) {
                    ++this.next_char_index;
                    return new String("" + current_char);
                }
                return label;
            }
            Object tmp_object = this.peeked_object;
            this.peeked_object = null;
            return tmp_object;
        }

        private Integer removeInteger() {
            String integer_string = "";
            char current_char = this.location_string.charAt(this.next_char_index);
            while (Character.isDigit(current_char)) {
                integer_string = integer_string + current_char;
                ++this.next_char_index;
                if (this.next_char_index >= this.location_string.length()) break;
                current_char = this.location_string.charAt(this.next_char_index);
            }
            return new Integer(integer_string);
        }

        private String removeLabel() {
            String return_string = "";
            char current_char = this.location_string.charAt(this.next_char_index);
            if (!Character.isLetter(current_char)) {
                return "";
            }
            while (Character.isLetterOrDigit(current_char) || current_char == '.' || current_char == '_' || current_char == '*' || current_char == '\'' || current_char == '-') {
                return_string = return_string + current_char;
                ++this.next_char_index;
                if (this.next_char_index >= this.location_string.length()) break;
                current_char = this.location_string.charAt(this.next_char_index);
            }
            return return_string;
        }
    }
}

