/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import uk.ac.sanger.artemis.io.FuzzyRange;
import uk.ac.sanger.artemis.io.LowerInteger;
import uk.ac.sanger.artemis.io.UpperInteger;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class Range {
    private int start;
    private int end;

    public Range(int start, int end) throws OutOfRangeException {
        if (end < start) {
            throw new OutOfRangeException("start: " + start + " > " + "end: " + end);
        }
        this.start = start;
        this.end = end;
    }

    public Range(int number) {
        this.start = number;
        this.end = number;
    }

    public int getCount() {
        return this.end - this.start + 1;
    }

    public String toString() {
        if (this.end > this.start) {
            return this.start + ".." + this.end;
        }
        return Integer.toString(this.start);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public Range copy() {
        try {
            return new Range(this.getStart(), this.getEnd());
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public boolean contains(Range test_range) {
        if (this.overlaps(test_range)) {
            return this.getStart() <= test_range.getStart() && this.getEnd() >= test_range.getEnd();
        }
        return false;
    }

    public Range change(int start, int end) throws OutOfRangeException {
        return new Range(start, end);
    }

    public Range truncate(Range constraint) {
        if (constraint.getEnd() < this.getStart()) {
            return null;
        }
        if (constraint.getStart() > this.getEnd()) {
            return null;
        }
        int new_start = this.getStart() - constraint.getStart() + 1;
        int new_end = this.getEnd() - constraint.getStart() + 1;
        Object start_object = new_start < 1 ? new LowerInteger(1) : new Integer(new_start);
        Object end_object = new_end > constraint.getCount() ? new UpperInteger(constraint.getCount()) : new Integer(new_end);
        try {
            return FuzzyRange.makeRange(start_object, end_object);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public boolean equals(Range test_range) {
        if (test_range instanceof Range) {
            return test_range.getStart() == this.getStart() && test_range.getEnd() == this.getEnd();
        }
        return false;
    }

    public boolean overlaps(Range arg_range) {
        if (this.getStart() < arg_range.getStart() && this.getEnd() < arg_range.getStart()) {
            return false;
        }
        return this.getStart() <= arg_range.getEnd() || this.getEnd() <= arg_range.getEnd();
    }
}

