/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public class RawStreamSequence
extends StreamSequence {
    private Vector fasta_header_positions = null;
    private Vector fasta_header_strings = null;

    public RawStreamSequence(LinePushBackReader in_stream) throws IOException {
        this.readSequence(in_stream);
    }

    public RawStreamSequence(Sequence sequence) {
        this(sequence.toString());
        if (sequence instanceof RawStreamSequence) {
            RawStreamSequence raw_stream_sequence = (RawStreamSequence)sequence;
            this.fasta_header_positions = (Vector)raw_stream_sequence.fasta_header_positions.clone();
            this.fasta_header_strings = (Vector)raw_stream_sequence.fasta_header_strings.clone();
        }
    }

    public RawStreamSequence(String sequence_string) {
        this.setFromString(sequence_string);
    }

    public StreamSequence copy() {
        return new RawStreamSequence(this);
    }

    public int getFormatType() {
        return 3;
    }

    protected void readHeader(LinePushBackReader in_stream) throws IOException {
    }

    protected void readSequence(LinePushBackReader in_stream) throws IOException {
        String line;
        this.fasta_header_positions = new Vector();
        this.fasta_header_strings = new Vector();
        int buffer_capacity = 50000;
        StringBuffer sequence_buffer = new StringBuffer(50000);
        while ((line = in_stream.readLine()) != null) {
            if (line.startsWith(">")) {
                String header_string = line.substring(1);
                Integer header_position = new Integer(sequence_buffer.length());
                this.fasta_header_strings.addElement(header_string);
                this.fasta_header_positions.addElement(header_position);
                continue;
            }
            line = line.toLowerCase();
            for (int i = 0; i < line.length(); ++i) {
                char this_char = line.charAt(i);
                if (Character.isLetter(this_char) || this_char == '.' || this_char == '-' || this_char == '*') {
                    sequence_buffer.append(this_char);
                    continue;
                }
                if (Character.isSpaceChar(this_char)) continue;
                throw new ReadFormatException("sequence file contains a character that is not a letter: " + this_char, in_stream.getLineNumber());
            }
        }
        this.setFromString(sequence_buffer.toString());
    }

    public void writeToStream(Writer writer) throws IOException {
        StringBuffer line_buffer = new StringBuffer(90);
        String sequence = this.toString();
        int SEQUENCE_LINE_BASE_COUNT = 60;
        int header_counter = 0;
        int[] header_positions = this.getFastaHeaderPositions();
        String[] header_strings = this.getFastaHeaderStrings();
        int i = 0;
        while (i < sequence.length()) {
            if (header_counter < header_positions.length && i == header_positions[header_counter]) {
                writer.write(">" + header_strings[header_counter] + "\n");
                ++header_counter;
            }
            int this_line_length = sequence.length() - i < 60 ? sequence.length() - i : 60;
            if (header_counter < header_positions.length && i + this_line_length > header_positions[header_counter]) {
                this_line_length = header_positions[header_counter] - i;
            }
            line_buffer.setLength(0);
            line_buffer.append(sequence.substring(i, i + this_line_length));
            line_buffer.append("\n");
            writer.write(line_buffer.toString());
            if (i / 60 % 100 == 0) {
                Thread.yield();
            }
            if (header_counter < header_positions.length && header_positions[header_counter] < i + 60) {
                i = header_positions[header_counter];
                continue;
            }
            i += 60;
        }
    }

    int[] getFastaHeaderPositions() {
        if (this.fasta_header_positions != null && this.fasta_header_positions.size() > 0) {
            int[] return_value = new int[this.fasta_header_positions.size()];
            for (int i = 0; i < return_value.length; ++i) {
                return_value[i] = (Integer)this.fasta_header_positions.elementAt(i);
            }
            return return_value;
        }
        return new int[0];
    }

    String[] getFastaHeaderStrings() {
        if (this.fasta_header_strings != null && this.fasta_header_strings.size() > 0) {
            String[] return_value = new String[this.fasta_header_strings.size()];
            for (int i = 0; i < return_value.length; ++i) {
                return_value[i] = (String)this.fasta_header_strings.elementAt(i);
            }
            return return_value;
        }
        return new String[0];
    }
}

