/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.lsf;

import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.lsf.LSFBatchException;
import uk.ac.sanger.jcon.run.BufferedStringSink;

public final class LSFBsubExec {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$lsf$LSFBsubExec == null ? (class$uk$ac$sanger$jcon$lsf$LSFBsubExec = LSFBsubExec.class$("uk.ac.sanger.jcon.lsf.LSFBsubExec")) : class$uk$ac$sanger$jcon$lsf$LSFBsubExec).getName());
    private static final LSFBsubExec INSTANCE = new LSFBsubExec();
    static /* synthetic */ Class class$uk$ac$sanger$jcon$lsf$LSFBsubExec;

    private LSFBsubExec() {
    }

    public static LSFBsubExec getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int submit(String jobName, String queue, String inFile, String outFile, String errFile, String command, String[] env, String workDir) throws Exception {
        if (workDir == null) {
            throw new IllegalArgumentException("The working directory may not be null");
        }
        ArrayList<String> bsubCommand = new ArrayList<String>();
        bsubCommand.add("bsub");
        bsubCommand.add("-J");
        bsubCommand.add(jobName);
        bsubCommand.add("-q");
        bsubCommand.add(queue);
        if (inFile != null) {
            bsubCommand.add("-i");
            bsubCommand.add(inFile);
        }
        if (outFile != null) {
            bsubCommand.add("-o");
            bsubCommand.add(outFile);
        }
        if (errFile != null) {
            bsubCommand.add("-e");
            bsubCommand.add(errFile);
        }
        bsubCommand.add(command);
        cat.debug((Object)("Running bsub command '" + bsubCommand + "' in " + workDir));
        File dir = new File(workDir);
        int lsfJobId = -1;
        try {
            Runtime runtime = Runtime.getRuntime();
            String[] tokens = bsubCommand.toArray(new String[0]);
            Process process = runtime.exec(tokens, env, dir);
            BufferedStringSink stdoutSink = new BufferedStringSink(process.getInputStream());
            BufferedStringSink stderrSink = new BufferedStringSink(process.getErrorStream());
            stdoutSink.start();
            stderrSink.start();
            int exitValue = process.waitFor();
            stdoutSink.join();
            stderrSink.join();
            String stdout = stdoutSink.getBuffer().substring(0);
            String stderr = stderrSink.getBuffer().substring(0);
            if (exitValue != 0) {
                throw new LSFBatchException("Recieved exit code " + exitValue + "from bsub with stderr '" + stderr + "'");
            }
            try {
                lsfJobId = this.parseBsubStdout(stdout);
            }
            catch (Exception e) {
                cat.error((Object)"Caught Exception ", (Throwable)e);
                throw new LSFBatchException("Failed to parse new Job ID from '" + stdout + "'");
            }
            Object var22_22 = null;
            process = null;
        }
        catch (Throwable throwable) {
            Object var22_23 = null;
            Object process = null;
            throw throwable;
        }
        return lsfJobId;
    }

    private int parseBsubStdout(String stdout) {
        int lAngle = stdout.indexOf(60);
        int rAngle = stdout.indexOf(62);
        return Integer.parseInt(stdout.substring(lAngle + 1, rAngle));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

