/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.RemoteFeature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.BetweenLocation;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.FuzzyPointLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.SmallMap;

public class EmblLikeLocationParser {
    private String location;
    private LocationLexer lexer;
    private int nextCharIndex;
    private Object thisToken;
    private String parentSeqID;
    private List instructStack = new ArrayList();
    private String joinType = null;
    private List subLocations = new ArrayList();
    private List subRegions = new ArrayList();
    private String mRegionSeqID;
    private List startCoords = new ArrayList();
    private List endCoords = new ArrayList();
    private boolean isPointLoc = true;
    private boolean fuzzyCoord = false;
    private boolean unboundMin = false;
    private boolean unboundMax = false;
    private boolean isBetweenLocation = false;
    private StrandedFeature.Strand mStrandType = StrandedFeature.POSITIVE;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Character;

    EmblLikeLocationParser(String parentSeqID) {
        this.lexer = new LocationLexer();
        this.parentSeqID = parentSeqID;
    }

    public Feature.Template parseLocation(String location, Feature.Template theTemplate) throws BioException {
        this.location = location;
        this.nextCharIndex = 0;
        this.instructStack.clear();
        this.subLocations.clear();
        this.subRegions.clear();
        this.joinType = null;
        this.thisToken = this.lexer.getNextToken();
        while (this.thisToken != null) {
            if ((class$java$lang$String == null ? EmblLikeLocationParser.class$("java.lang.String") : class$java$lang$String).isInstance(this.thisToken)) {
                String toke = (String)this.thisToken;
                if (toke.equals("..")) {
                    this.isPointLoc = false;
                } else {
                    this.instructStack.add(this.thisToken);
                }
            } else if ((class$java$lang$Integer == null ? EmblLikeLocationParser.class$("java.lang.Integer") : class$java$lang$Integer).isInstance(this.thisToken)) {
                if (this.isPointLoc) {
                    this.startCoords.add(this.thisToken);
                } else {
                    this.endCoords.add(this.thisToken);
                }
            } else if ((class$java$lang$Character == null ? EmblLikeLocationParser.class$("java.lang.Character") : class$java$lang$Character).isInstance(this.thisToken)) {
                char toke = ((Character)this.thisToken).charValue();
                switch (toke) {
                    case '(': {
                        break;
                    }
                    case ':': {
                        this.processInstructs();
                        break;
                    }
                    case '^': {
                        this.isBetweenLocation = true;
                        break;
                    }
                    case '<': {
                        this.unboundMin = true;
                        break;
                    }
                    case '>': {
                        this.unboundMax = true;
                        break;
                    }
                    case '.': {
                        this.fuzzyCoord = true;
                        break;
                    }
                    case ',': {
                        this.processCoords();
                        break;
                    }
                    case ')': {
                        if (this.fuzzyCoord) {
                            this.fuzzyCoord = false;
                            break;
                        }
                        this.processCoords();
                        this.processInstructs();
                        break;
                    }
                    default: {
                        throw new BioException("Unknown character '" + toke + "' within location: " + location);
                    }
                }
            }
            this.thisToken = this.lexer.getNextToken();
        }
        this.processCoords();
        theTemplate.location = this.subLocations.size() == 1 ? (Location)this.subLocations.get(0) : LocationTools.union(this.subLocations);
        if (theTemplate instanceof StrandedFeature.Template) {
            ((StrandedFeature.Template)theTemplate).strand = this.mStrandType;
        }
        if (this.subRegions.size() > this.subLocations.size()) {
            RemoteFeature.Template newTemplate = new RemoteFeature.Template(theTemplate);
            newTemplate.regions = new ArrayList(this.subRegions);
            newTemplate.resolver = null;
            theTemplate = newTemplate;
        }
        if (this.joinType != null) {
            try {
                SmallMap dat = new SmallMap();
                dat.put("JoinType", this.joinType);
                theTemplate.annotation.setProperty("internal_data", dat);
            }
            catch (ChangeVetoException cve) {
                throw new BioError(cve);
            }
        }
        return theTemplate;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCoords() throws BioException {
        void var5_11;
        Object var5_1 = null;
        if (this.startCoords.isEmpty() && this.endCoords.isEmpty()) {
            return;
        }
        if (this.isBetweenLocation) {
            int minCoord = (Integer)this.startCoords.get(0);
            int maxCoord = (Integer)this.startCoords.get(1);
            BetweenLocation betweenLocation = new BetweenLocation(new RangeLocation(minCoord, maxCoord));
        } else if (this.startCoords.size() == 1 && this.endCoords.isEmpty()) {
            int outerMin;
            int innerMin;
            int outerMax;
            int innerMax = outerMax = (innerMin = (outerMin = ((Integer)this.startCoords.get(0)).intValue()));
            if (this.unboundMin || this.unboundMax) {
                FuzzyPointLocation fuzzyPointLocation = new FuzzyPointLocation(this.unboundMin ? Integer.MIN_VALUE : innerMin, this.unboundMax ? Integer.MAX_VALUE : innerMax, FuzzyPointLocation.RESOLVE_AVERAGE);
            } else {
                if (!this.isPointLoc) throw new BioException("Internal error in location parsing; parser became confused: " + this.location);
                PointLocation pointLocation = new PointLocation(innerMin);
            }
        } else if (this.startCoords.size() == 2 && this.endCoords.isEmpty()) {
            int outerMax;
            int outerMin;
            int innerMin = outerMin = ((Integer)this.startCoords.get(0)).intValue();
            int innerMax = outerMax = ((Integer)this.startCoords.get(1)).intValue();
            FuzzyPointLocation fuzzyPointLocation = new FuzzyPointLocation(innerMin, innerMax, FuzzyPointLocation.RESOLVE_AVERAGE);
        } else if (this.startCoords.size() == 1 && this.endCoords.size() == 1) {
            int outerMax;
            int outerMin;
            int innerMin = outerMin = ((Integer)this.startCoords.get(0)).intValue();
            int innerMax = outerMax = ((Integer)this.endCoords.get(0)).intValue();
            if (this.unboundMin || this.unboundMax) {
                FuzzyLocation fuzzyLocation = new FuzzyLocation(this.unboundMin ? Integer.MIN_VALUE : outerMin, this.unboundMax ? Integer.MAX_VALUE : outerMax, innerMin, innerMax, FuzzyLocation.RESOLVE_INNER);
            } else {
                try {
                    RangeLocation rangeLocation = new RangeLocation(outerMin, outerMax);
                }
                catch (IndexOutOfBoundsException ioe) {
                    throw new BioException(ioe);
                }
            }
        } else if (this.startCoords.size() == 2 && this.endCoords.size() == 1) {
            int outerMax;
            int outerMin = (Integer)this.startCoords.get(0);
            int innerMin = (Integer)this.startCoords.get(1);
            int innerMax = outerMax = ((Integer)this.endCoords.get(0)).intValue();
            FuzzyLocation fuzzyLocation = new FuzzyLocation(outerMin, outerMax, innerMin, innerMax, FuzzyLocation.RESOLVE_INNER);
        } else if (this.startCoords.size() == 1 && this.endCoords.size() == 2) {
            int innerMin;
            int outerMin = innerMin = ((Integer)this.startCoords.get(0)).intValue();
            int innerMax = (Integer)this.endCoords.get(0);
            int outerMax = (Integer)this.endCoords.get(1);
            FuzzyLocation fuzzyLocation = new FuzzyLocation(outerMin, outerMax, innerMin, innerMax, FuzzyLocation.RESOLVE_INNER);
        } else {
            if (this.startCoords.size() != 2 || this.endCoords.size() != 2) throw new BioException("Internal error in location parsing; parser became confused; " + this.location);
            int outerMin = (Integer)this.startCoords.get(0);
            int innerMin = (Integer)this.startCoords.get(1);
            int innerMax = (Integer)this.endCoords.get(0);
            int outerMax = (Integer)this.endCoords.get(1);
            FuzzyLocation fuzzyLocation = new FuzzyLocation(outerMin, outerMax, innerMin, innerMax, FuzzyLocation.RESOLVE_INNER);
        }
        this.startCoords.clear();
        this.endCoords.clear();
        if (this.mRegionSeqID == null) {
            this.subLocations.add(var5_11);
            this.subRegions.add(new RemoteFeature.Region((Location)var5_11, this.parentSeqID, false));
        } else {
            this.subRegions.add(new RemoteFeature.Region((Location)var5_11, this.mRegionSeqID, true));
        }
        this.mRegionSeqID = null;
        this.isPointLoc = true;
        this.unboundMin = false;
        this.unboundMax = false;
        this.fuzzyCoord = false;
        this.isBetweenLocation = false;
        this.mStrandType = StrandedFeature.POSITIVE;
    }

    private void processInstructs() throws BioException {
        String instruct = (String)this.instructStack.remove(this.instructStack.size() - 1);
        if (instruct.equals("join") || instruct.equals("order")) {
            this.joinType = instruct;
        } else if (instruct.equals("complement")) {
            this.mStrandType = StrandedFeature.NEGATIVE;
        } else {
            this.mRegionSeqID = instruct;
        }
    }

    private int countChar(String s, char c) {
        int cnt = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++cnt;
        }
        return cnt;
    }

    private class LocationLexer {
        private StringBuffer intString = new StringBuffer();
        private StringBuffer textString = new StringBuffer();

        private LocationLexer() {
        }

        Object getNextToken() {
            char thisChar;
            block6: while (true) {
                if (EmblLikeLocationParser.this.nextCharIndex == EmblLikeLocationParser.this.location.length()) {
                    return null;
                }
                thisChar = EmblLikeLocationParser.this.location.charAt(EmblLikeLocationParser.this.nextCharIndex);
                switch (thisChar) {
                    case '\t': 
                    case ' ': {
                        EmblLikeLocationParser.this.nextCharIndex++;
                        continue block6;
                    }
                    case '(': 
                    case ')': 
                    case ',': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '^': {
                        EmblLikeLocationParser.this.nextCharIndex++;
                        return new Character(thisChar);
                    }
                    case '.': {
                        if (EmblLikeLocationParser.this.location.charAt(EmblLikeLocationParser.this.nextCharIndex + 1) == '.') {
                            EmblLikeLocationParser.this.nextCharIndex += 2;
                            return "..";
                        }
                        EmblLikeLocationParser.this.nextCharIndex++;
                        return new Character('.');
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return this.followInteger();
                    }
                }
                break;
            }
            String text = this.followText();
            if (text.equals("")) {
                EmblLikeLocationParser.this.nextCharIndex++;
                return new String("" + thisChar);
            }
            return text;
        }

        private Integer followInteger() {
            this.intString.setLength(0);
            char thisChar = EmblLikeLocationParser.this.location.charAt(EmblLikeLocationParser.this.nextCharIndex);
            while (Character.isDigit(thisChar)) {
                this.intString.append(thisChar);
                EmblLikeLocationParser.this.nextCharIndex++;
                if (EmblLikeLocationParser.this.nextCharIndex >= EmblLikeLocationParser.this.location.length()) break;
                thisChar = EmblLikeLocationParser.this.location.charAt(EmblLikeLocationParser.this.nextCharIndex);
            }
            return new Integer(this.intString.substring(0));
        }

        private String followText() {
            this.textString.setLength(0);
            char thisChar = EmblLikeLocationParser.this.location.charAt(EmblLikeLocationParser.this.nextCharIndex);
            if (!Character.isLetter(thisChar)) {
                return "";
            }
            while (Character.isLetterOrDigit(thisChar) || thisChar == '.') {
                this.textString.append(thisChar);
                EmblLikeLocationParser.this.nextCharIndex++;
                if (EmblLikeLocationParser.this.nextCharIndex >= EmblLikeLocationParser.this.location.length()) break;
                thisChar = EmblLikeLocationParser.this.location.charAt(EmblLikeLocationParser.this.nextCharIndex);
            }
            return this.textString.substring(0);
        }
    }
}

